from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = "websphere.indirectlookupnamespacebinding.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'IndirectLookupNameSpaceBinding');

  containmentpath = "%(parentconpath)sIndirectLookupNameSpaceBinding:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('IndirectLookupNameSpaceBinding')

  name = Util.getRequiredAttribute(objid, "name", 'IndirectLookupNameSpaceBinding');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereIndirectLookupNameSpaceBinding");
  exportedObject.put("roleName", "WebSphereIndirectLookupNameSpaceBinding");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.indirectlookupnamespacebinding.name", objid, "name","IndirectLookupNameSpaceBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.indirectlookupnamespacebinding.providerurl", objid, "providerURL","IndirectLookupNameSpaceBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.indirectlookupnamespacebinding.nameinnamespace", objid, "nameInNameSpace","IndirectLookupNameSpaceBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.indirectlookupnamespacebinding.initialcontextfactory", objid, "initialContextFactory","IndirectLookupNameSpaceBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.indirectlookupnamespacebinding.jndiname", objid, "jndiName","IndirectLookupNameSpaceBinding");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"IndirectLookupNameSpaceBinding");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('IndirectLookupNameSpaceBinding');
  return result;

def doImportPartial(containmentpath, roleName, jsonobject):
  doImport(containmentpath, roleName, jsonobject);

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("IndirectLookupNameSpaceBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.indirectlookupnamespacebinding.name"):
    raise Exception("Resource role properties does not contain websphere.indirectlookupnamespacebinding.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    if Util.__removePartialConfig__ == "false":
      index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
      parentconpath = containmentpath[0:index];
      parentid = Util.getid(parentconpath);
      if parentid == None or len(parentid) == 0:
        raise Exception("Parent does not exist to create IndirectLookupNameSpaceBinding on.");
      objid = create(parentid, jsonobject);
  else:
    if Util.__removePartialConfig__ == "true":
      Util.removePartialApply(objid);
      objid = None;
    else:
      update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('IndirectLookupNameSpaceBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("IndirectLookupNameSpaceBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.indirectlookupnamespacebinding.name"):
    raise Exception("Resource role properties does not contain websphere.indirectlookupnamespacebinding.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.indirectlookupnamespacebinding.name", None));
  Util.addIfNotNone(properties, "providerURL", roleProperties.optString("websphere.indirectlookupnamespacebinding.providerurl", None));
  Util.addIfNotNone(properties, "nameInNameSpace", roleProperties.optString("websphere.indirectlookupnamespacebinding.nameinnamespace", None));
  Util.addIfNotNone(properties, "initialContextFactory", roleProperties.optString("websphere.indirectlookupnamespacebinding.initialcontextfactory", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.indirectlookupnamespacebinding.jndiname", None));
  print "Creating IndirectLookupNameSpaceBinding with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("IndirectLookupNameSpaceBinding", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('IndirectLookupNameSpaceBinding');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('IndirectLookupNameSpaceBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("IndirectLookupNameSpaceBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.indirectlookupnamespacebinding.name"):
    raise Exception("Resource role properties does not contain websphere.indirectlookupnamespacebinding.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.indirectlookupnamespacebinding.name", None), "name","IndirectLookupNameSpaceBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.indirectlookupnamespacebinding.providerurl", None), "providerURL","IndirectLookupNameSpaceBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.indirectlookupnamespacebinding.nameinnamespace", None), "nameInNameSpace","IndirectLookupNameSpaceBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.indirectlookupnamespacebinding.initialcontextfactory", None), "initialContextFactory","IndirectLookupNameSpaceBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.indirectlookupnamespacebinding.jndiname", None), "jndiName","IndirectLookupNameSpaceBinding");
  if len(atts) != 0:
    print "Modifying IndirectLookupNameSpaceBinding with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "IndirectLookupNameSpaceBinding configuration up to date.";

  Property.removeProperties(objid, 'properties',"IndirectLookupNameSpaceBinding");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('IndirectLookupNameSpaceBinding');
