from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBWSSecurityRequestConsumerBindingConfig')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBWSSecurityRequestConsumerBindingConfig");
  exportedObject.put("roleName", "WebSphereSIBWSSecurityRequestConsumerBindingConfig");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwssecurityrequestconsumerbindingconfig.name", objid, "name","SIBWSSecurityRequestConsumerBindingConfig");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBWSSecurityRequestConsumerBindingConfig');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBWSSecurityRequestConsumerBindingConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSSecurityRequestConsumerBindingConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibwssecurityrequestconsumerbindingconfig.name", None));
  print "Creating SIBWSSecurityRequestConsumerBindingConfig with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBWSSecurityRequestConsumerBindingConfig", parentid, properties);
  Util.popPathElement('SIBWSSecurityRequestConsumerBindingConfig');

def update(objid,jsonobject):
  Util.pushPathElement('SIBWSSecurityRequestConsumerBindingConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSSecurityRequestConsumerBindingConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwssecurityrequestconsumerbindingconfig.name", None), "name","SIBWSSecurityRequestConsumerBindingConfig");
  if len(atts) != 0:
    print "Modifying SIBWSSecurityRequestConsumerBindingConfig with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBWSSecurityRequestConsumerBindingConfig configuration up to date.";

  Util.popPathElement('SIBWSSecurityRequestConsumerBindingConfig');
