from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = "websphere.webcontainerinboundchannel.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'WebContainerInboundChannel');

  containmentpath = "%(parentconpath)sWebContainerInboundChannel:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('WebContainerInboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'WebContainerInboundChannel');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWebContainerInboundChannel");
  exportedObject.put("roleName", "WebSphereWebContainerInboundChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webcontainerinboundchannel.writebuffersize", objid, "writeBufferSize","WebContainerInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webcontainerinboundchannel.enablefrca", objid, "enableFRCA","WebContainerInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webcontainerinboundchannel.name", objid, "name","WebContainerInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webcontainerinboundchannel.discriminationweight", objid, "discriminationWeight","WebContainerInboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"WebContainerInboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WebContainerInboundChannel');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("WebContainerInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.webcontainerinboundchannel.name"):
    raise Exception("Resource role properties does not contain websphere.webcontainerinboundchannel.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create WebContainerInboundChannel on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('WebContainerInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("WebContainerInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.webcontainerinboundchannel.name"):
    raise Exception("Resource role properties does not contain websphere.webcontainerinboundchannel.name!");

  properties = [];
  Util.addIfNotNone(properties, "writeBufferSize", roleProperties.optString("websphere.webcontainerinboundchannel.writebuffersize", None));
  Util.addIfNotNone(properties, "enableFRCA", roleProperties.optString("websphere.webcontainerinboundchannel.enablefrca", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.webcontainerinboundchannel.name", None));
  Util.addIfNotNone(properties, "discriminationWeight", roleProperties.optString("websphere.webcontainerinboundchannel.discriminationweight", None));
  print "Creating WebContainerInboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WebContainerInboundChannel", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WebContainerInboundChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('WebContainerInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("WebContainerInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.webcontainerinboundchannel.name"):
    raise Exception("Resource role properties does not contain websphere.webcontainerinboundchannel.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webcontainerinboundchannel.writebuffersize", None), "writeBufferSize","WebContainerInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webcontainerinboundchannel.enablefrca", None), "enableFRCA","WebContainerInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webcontainerinboundchannel.name", None), "name","WebContainerInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webcontainerinboundchannel.discriminationweight", None), "discriminationWeight","WebContainerInboundChannel");
  if len(atts) != 0:
    print "Modifying WebContainerInboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WebContainerInboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"WebContainerInboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('WebContainerInboundChannel');
