###
# Licensed Materials - Property of IBM* and/or HCL**
#
# (c) Copyright IBM Corporation 2014, 2015, 2017. All Rights Reserved.
# (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
#
# U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
# GSA ADP Schedule Contract with IBM Corp.
#
# * Trademark of International Business Machines
# ** Trademark of HCL Technologies Limited

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from ActivationSpecRef import ActivationSpecRef
from J2EEResourceProperty import J2EEResourceProperty
from J2EEResourcePropertySet import J2EEResourcePropertySet

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ActivationSpecTemplateProps')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereActivationSpecTemplateProps");
  exportedObject.put("roleName", "WebSphereActivationSpecTemplateProps");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  activationSpec = Util.getOptionalAttribute(objid, 'activationSpec', 'ActivationSpecTemplateProps');
  if activationSpec is not None and len(activationSpec) > 0:
    returndict = Util.createTypeFolder(respath, "ActivationSpecRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ActivationSpecRef._export(activationSpec, currespath, "ActivationSpec"));

  resourceProperties = Util.parseConfigIdListAttribute(objid, 'resourceProperties', 'ActivationSpecTemplateProps');
  for resprop in resourceProperties:
    if len(resprop) > 0:
      returndict = Util.createTypeFolder(respath, "J2EEResourceProperty", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, J2EEResourceProperty._export(resprop, currespath));

  complexPropertySet = Util.getOptionalAttribute(objid, 'complexPropertySet', "ActivationSpecTemplateProps");
  if complexPropertySet is not None and len(complexPropertySet) > 0:
   returndict = Util.createTypeFolder(respath, "J2EEResourcePropertySet", typeFolders);
   currespath = returndict['path'];
   if returndict.has_key('object'):
     Util.addFromExport(extraObjects, returndict['object']);
   Util.addAllFromExport(extraObjects, J2EEResourcePropertySet._export(complexPropertySet, currespath, "J2EEResourcePropertySet"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ActivationSpecTemplateProps');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ActivationSpecTemplateProps')
  if not jsonobject.has("roleProperties"):
    raise Exception("ActivationSpecTemplateProps resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating ActivationSpecTemplateProps with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ActivationSpecTemplateProps", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereJ2EEResourceProperty":
        J2EEResourceProperty.create(objid, curjsonobject);
      elif currole == "WebSphereJ2EEResourcePropertySet":
        J2EEResourcePropertySet.create(objid, curjsonobject);
      elif currole == "WebSphereActivationSpecRef":
        ActivationSpecRef.doImport(objid, curjsonobject);
  Util.popPathElement('ActivationSpecTemplateProps');


def update(objid,jsonobject):
  Util.pushPathElement('ActivationSpecTemplateProps')
  if not jsonobject.has("roleProperties"):
    raise Exception("ActivationSpecTemplateProps resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying ActivationSpecTemplateProps with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ActivationSpecTemplateProps configuration up to date.";

  Util.unsetAttribute(objid, "activationSpec", "ActivationSpecTemplateProps");
  propSet = Util.getOptionalAttribute(objid, 'complexPropertySet', 'ActivationSpecTemplateProps');
  if propSet is not None and len(propSet) > 0:
    Util.remove(propSet);

  resourceProperties = Util.parseConfigIdListAttribute(objid, 'resourceProperties', 'ActivationSpecTemplateProps');
  for resprop in resourceProperties:
    if len(resprop) > 0:
      Util.remove(resprop);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereJ2EEResourceProperty":
        J2EEResourceProperty.create(objid, curjsonobject);
      elif currole == "WebSphereJ2EEResourcePropertySet":
        J2EEResourcePropertySet.create(objid, curjsonobject);
      elif currole == "WebSphereActivationSpecRef":
        ActivationSpecRef.doImport(objid, curjsonobject);

  Util.popPathElement('ActivationSpecTemplateProps');
