from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('J2EEResourceProvider')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJ2EEResourceProvider");
  exportedObject.put("roleName", "WebSphereJ2EEResourceProvider");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.j2eeresourceprovider.classpath", objid, "classpath","J2EEResourceProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeresourceprovider.name", objid, "name","J2EEResourceProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeresourceprovider.isolatedclassloader", objid, "isolatedClassLoader","J2EEResourceProvider");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.j2eeresourceprovider.nativepath", objid, "nativepath","J2EEResourceProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeresourceprovider.description", objid, "description","J2EEResourceProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeresourceprovider.providertype", objid, "providerType","J2EEResourceProvider");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('J2EEResourceProvider');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('J2EEResourceProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("J2EEResourceProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addPathProperty(properties, "classpath", roleProperties.optString("websphere.j2eeresourceprovider.classpath", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.j2eeresourceprovider.name", None));
  Util.addIfNotNone(properties, "isolatedClassLoader", roleProperties.optString("websphere.j2eeresourceprovider.isolatedclassloader", None));
  Util.addPathProperty(properties, "nativepath", roleProperties.optString("websphere.j2eeresourceprovider.nativepath", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.j2eeresourceprovider.description", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.j2eeresourceprovider.providertype", None));
  print "Creating J2EEResourceProvider with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("J2EEResourceProvider", parentid, properties);
  Util.popPathElement('J2EEResourceProvider');

def update(objid,jsonobject):
  Util.pushPathElement('J2EEResourceProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("J2EEResourceProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeresourceprovider.classpath", None), "classpath","J2EEResourceProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeresourceprovider.name", None), "name","J2EEResourceProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeresourceprovider.isolatedclassloader", None), "isolatedClassLoader","J2EEResourceProvider");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeresourceprovider.nativepath", None), "nativepath","J2EEResourceProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeresourceprovider.description", None), "description","J2EEResourceProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeresourceprovider.providertype", None), "providerType","J2EEResourceProvider");
  if len(atts) != 0:
    print "Modifying J2EEResourceProvider with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "J2EEResourceProvider configuration up to date.";

  Util.popPathElement('J2EEResourceProvider');
