from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Referenceable')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereReferenceable");
  exportedObject.put("roleName", "WebSphereReferenceable");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.referenceable.factoryclassname", objid, "factoryClassname","Referenceable");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.referenceable.classname", objid, "classname","Referenceable");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Referenceable');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Referenceable')
  if not jsonobject.has("roleProperties"):
    raise Exception("Referenceable resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "factoryClassname", roleProperties.optString("websphere.referenceable.factoryclassname", None));
  Util.addIfNotNone(properties, "classname", roleProperties.optString("websphere.referenceable.classname", None));
  print "Creating Referenceable with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Referenceable", parentid, properties);
  Util.popPathElement('Referenceable');

def update(objid,jsonobject):
  Util.pushPathElement('Referenceable')
  if not jsonobject.has("roleProperties"):
    raise Exception("Referenceable resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.referenceable.factoryclassname", None), "factoryClassname","Referenceable");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.referenceable.classname", None), "classname","Referenceable");
  if len(atts) != 0:
    print "Modifying Referenceable with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Referenceable configuration up to date.";

  Util.popPathElement('Referenceable');
