from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('URIGroup')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereURIGroup");
  exportedObject.put("roleName", "WebSphereURIGroup");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.urigroup.uripattern", objid, "URIPattern","URIGroup");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.urigroup.name", objid, "name","URIGroup");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('URIGroup');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('URIGroup')
  if not jsonobject.has("roleProperties"):
    raise Exception("URIGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addPathProperty(properties, "URIPattern", roleProperties.optString("websphere.urigroup.uripattern", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.urigroup.name", None));
  print "Creating URIGroup with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("URIGroup", parentid, properties);
  Util.popPathElement('URIGroup');

def update(objid,jsonobject):
  Util.pushPathElement('URIGroup')
  if not jsonobject.has("roleProperties"):
    raise Exception("URIGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.urigroup.uripattern", None), "URIPattern","URIGroup");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.urigroup.name", None), "name","URIGroup");
  if len(atts) != 0:
    print "Modifying URIGroup with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "URIGroup configuration up to date.";

  Util.popPathElement('URIGroup');
