###
# Licensed Materials - Property of IBM* and/or HCL**
#
# (c) Copyright IBM Corporation 2015, 2017. All Rights Reserved.
# (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
#
# U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
# GSA ADP Schedule Contract with IBM Corp.
#
# * Trademark of International Business Machines
# ** Trademark of HCL Technologies Limited

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = None;


def _export(objid, parentrespath, resname):
  Util.pushPathElement('ActivationSpecRef')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':resname }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", resname);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereActivationSpecRef");
  exportedObject.put("roleName", "WebSphereActivationSpecRef");

  roleProperties = JSONObject();
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.activationspec.activationspecclass", objid, "activationSpecClass", "ActivationSpec");

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ActivationSpecRef');
  return result;

def doImport(parentid, jsonobject):
  referencedActivationSpec = getReferencedActivationSpec(parentid, jsonobject);
  #no need to push any path elements, as the parent will be calling directly into the import meaning that its path element should already be pushed
  Util.modify(parentid, [['activationSpec', referencedActivationSpec]]);


def getReferencedActivationSpec(parentid, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("ActivationSpecRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has('websphere.activationspec.activationspecclass'):
    raise Exception("ActivationSpecRef resource has no property named websphere.activationspec.activationspecclass!");

  targetActivationSpecClass = roleProperties.getString('websphere.activationspec.activationspecclass');
  referencedActivationSpec = None;

  # to find the scope of the ActivationSpec we are looking for,
  # take the parentid and get everything between the first / and |
  # example parentid = test(cells/CloudBurstCell_1/nodes/CloudBurstNode_1|resources.xml#J2CActivationSpec_1431703712950)
  # this would make parentScope below = /CloudBurstCell_1/nodes/CloudBurstNode_1
  parentScope = Util.getScope(parentid);
  # get all ActivationSpecs
  activationSpecs = Util.getid("/ActivationSpec:/").splitlines();
  if len(activationSpecs) > 0:
    for activationSpec in activationSpecs:
      if len(activationSpec) > 0:
        # see if this ActivationSpec id contains the same scope as the parentid
        activationSpecScope = Util.getScope(activationSpec);
        if activationSpecScope == parentScope:
        # now that we know the activationSpec is in the same scope as our parent object,
        # get the activationSpecClass attribute of this ActivationSpec
        # and see if they match the values in our JSON object
          activationSpecClass = Util.getOptionalAttribute(activationSpec, "activationSpecClass", "ActivationSpec");
          if activationSpecClass != None or len(activationSpecClass) > 0:
            if activationSpecClass == targetActivationSpecClass:
              referencedActivationSpec = activationSpec;
              break;

  if referencedActivationSpec == None or len(referencedActivationSpec) == 0:
      raise Exception("Could not find ActivationSpec with activationspecclass " + targetActivationSpecClass + " in scope " + parentScope + ".");
  return referencedActivationSpec;

