from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = "websphere.ruleset.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'Ruleset');

  containmentpath = "%(parentconpath)sRuleset:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('Ruleset')

  name = Util.getRequiredAttribute(objid, "name", 'Ruleset');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereRuleset");
  exportedObject.put("roleName", "WebSphereRuleset");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ruleset.name", objid, "name","Ruleset");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ruleset.type", objid, "type","Ruleset");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ruleset.defaultcontinue", objid, "defaultContinue","Ruleset");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"Ruleset");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Ruleset');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("Ruleset resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.ruleset.name"):
    raise Exception("Resource role properties does not contain websphere.ruleset.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create Ruleset on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('Ruleset')
  if not jsonobject.has("roleProperties"):
    raise Exception("Ruleset resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.ruleset.name"):
    raise Exception("Resource role properties does not contain websphere.ruleset.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.ruleset.name", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.ruleset.type", None));
  Util.addIfNotNone(properties, "defaultContinue", roleProperties.optString("websphere.ruleset.defaultcontinue", None));
  print "Creating Ruleset with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Ruleset", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('Ruleset');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('Ruleset')
  if not jsonobject.has("roleProperties"):
    raise Exception("Ruleset resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.ruleset.name"):
    raise Exception("Resource role properties does not contain websphere.ruleset.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ruleset.name", None), "name","Ruleset");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ruleset.type", None), "type","Ruleset");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ruleset.defaultcontinue", None), "defaultContinue","Ruleset");
  if len(atts) != 0:
    print "Modifying Ruleset with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Ruleset configuration up to date.";

  Property.removeProperties(objid, 'properties',"Ruleset");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('Ruleset');
