from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBVirtualLink')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBVirtualLink");
  exportedObject.put("roleName", "WebSphereSIBVirtualLink");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibvirtuallink.inbounduserid", objid, "inboundUserid","SIBVirtualLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibvirtuallink.name", objid, "name","SIBVirtualLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibvirtuallink.uuid", objid, "uuid","SIBVirtualLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibvirtuallink.outbounduserid", objid, "outboundUserid","SIBVirtualLink");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBVirtualLink');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBVirtualLink')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBVirtualLink resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "inboundUserid", roleProperties.optString("websphere.sibvirtuallink.inbounduserid", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibvirtuallink.name", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibvirtuallink.uuid", None));
  Util.addIfNotNone(properties, "outboundUserid", roleProperties.optString("websphere.sibvirtuallink.outbounduserid", None));
  print "Creating SIBVirtualLink with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBVirtualLink", parentid, properties);
  Util.popPathElement('SIBVirtualLink');

def update(objid,jsonobject):
  Util.pushPathElement('SIBVirtualLink')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBVirtualLink resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibvirtuallink.inbounduserid", None), "inboundUserid","SIBVirtualLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibvirtuallink.name", None), "name","SIBVirtualLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibvirtuallink.uuid", None), "uuid","SIBVirtualLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibvirtuallink.outbounduserid", None), "outboundUserid","SIBVirtualLink");
  if len(atts) != 0:
    print "Modifying SIBVirtualLink with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBVirtualLink configuration up to date.";

  Util.popPathElement('SIBVirtualLink');
