from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBWSSecurityRequestReceiverBindingConfig')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBWSSecurityRequestReceiverBindingConfig");
  exportedObject.put("roleName", "WebSphereSIBWSSecurityRequestReceiverBindingConfig");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwssecurityrequestreceiverbindingconfig.name", objid, "name","SIBWSSecurityRequestReceiverBindingConfig");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBWSSecurityRequestReceiverBindingConfig');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBWSSecurityRequestReceiverBindingConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSSecurityRequestReceiverBindingConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibwssecurityrequestreceiverbindingconfig.name", None));
  print "Creating SIBWSSecurityRequestReceiverBindingConfig with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBWSSecurityRequestReceiverBindingConfig", parentid, properties);
  Util.popPathElement('SIBWSSecurityRequestReceiverBindingConfig');

def update(objid,jsonobject):
  Util.pushPathElement('SIBWSSecurityRequestReceiverBindingConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSSecurityRequestReceiverBindingConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwssecurityrequestreceiverbindingconfig.name", None), "name","SIBWSSecurityRequestReceiverBindingConfig");
  if len(atts) != 0:
    print "Modifying SIBWSSecurityRequestReceiverBindingConfig with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBWSSecurityRequestReceiverBindingConfig configuration up to date.";

  Util.popPathElement('SIBWSSecurityRequestReceiverBindingConfig');
