from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIPApplicationRouter')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIPApplicationRouter");
  exportedObject.put("roleName", "WebSphereSIPApplicationRouter");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipapplicationrouter.name", objid, "name","SIPApplicationRouter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipapplicationrouter.sipapplicationrouterprovider", objid, "sipApplicationRouterProvider","SIPApplicationRouter");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"SIPApplicationRouter");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIPApplicationRouter');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIPApplicationRouter')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIPApplicationRouter resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sipapplicationrouter.name", None));
  Util.addIfNotNone(properties, "sipApplicationRouterProvider", roleProperties.optString("websphere.sipapplicationrouter.sipapplicationrouterprovider", None));
  print "Creating SIPApplicationRouter with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIPApplicationRouter", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIPApplicationRouter');

def update(objid,jsonobject):
  Util.pushPathElement('SIPApplicationRouter')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIPApplicationRouter resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipapplicationrouter.name", None), "name","SIPApplicationRouter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipapplicationrouter.sipapplicationrouterprovider", None), "sipApplicationRouterProvider","SIPApplicationRouter");
  if len(atts) != 0:
    print "Modifying SIPApplicationRouter with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIPApplicationRouter configuration up to date.";

  Property.removeProperties(objid, 'properties',"SIPApplicationRouter");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIPApplicationRouter');
