from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from InboundTransportChannel import InboundTransportChannel
from OutboundTransportChannel import OutboundTransportChannel
from TCPInboundChannel import TCPInboundChannel
from JFAPInboundChannel import JFAPInboundChannel
from HTTPInboundChannel import HTTPInboundChannel
from MQFAPInboundChannel import MQFAPInboundChannel
from WebContainerInboundChannel import WebContainerInboundChannel
from SSLInboundChannel import SSLInboundChannel
from HTTPTunnelInboundChannel import HTTPTunnelInboundChannel
from TCPOutboundChannel import TCPOutboundChannel
from HTTPOutboundChannel import HTTPOutboundChannel
from HTTPTunnelOutboundChannel import HTTPTunnelOutboundChannel
from SSLOutboundChannel import SSLOutboundChannel
from JFAPOutboundChannel import JFAPOutboundChannel
from MQFAPOutboundChannel import MQFAPOutboundChannel
from DCSInboundChannel import DCSInboundChannel
from GenericInboundChannel import GenericInboundChannel
from GenericOutboundChannel import GenericOutboundChannel
from SIPInboundChannel import SIPInboundChannel
from SIPContainerInboundChannel import SIPContainerInboundChannel
from UDPInboundChannel import UDPInboundChannel
from SIPProxyInboundChannel import SIPProxyInboundChannel
from SIPOutboundChannel import SIPOutboundChannel
from UDPOutboundChannel import UDPOutboundChannel
from ORBInboundChannel import ORBInboundChannel
from HTTPQueueInboundChannel import HTTPQueueInboundChannel
from DataPowerMgrInboundChannel import DataPowerMgrInboundChannel
from ProxyInboundChannel import ProxyInboundChannel
from RMQOutboundChannel import RMQOutboundChannel
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TransportChannel')

  ownName = Util.getOptionalAttribute(objid, "name", 'TransportChannel');
  if ownName is not None and len(ownName) > 0:
    name = ownName;

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTransportChannel");
  exportedObject.put("roleName", "WebSphereTransportChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transportchannel.name", objid, "name","TransportChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"TransportChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TransportChannel');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('TransportChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("TransportChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.transportchannel.name", None));
  print "Creating TransportChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TransportChannel", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('TransportChannel');

def update(objid,jsonobject):
  Util.pushPathElement('TransportChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("TransportChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transportchannel.name", None), "name","TransportChannel");
  if len(atts) != 0:
    print "Modifying TransportChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TransportChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"TransportChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('TransportChannel');


def removeTransportChannels(objid, attributeName, parentType):
  channels = Util.parseConfigIdListAttribute(objid, attributeName, parentType);
  if channels is not None and len(channels) > 0:
    for channel in channels:
      if len(channel) > 0:
        Util.remove(channel);

def exportTransportChannels(objid, respath, extraObjects, typeFolders, attributeName, parentType):
  counterTransportChannel = 0;

  channels = Util.parseConfigIdListAttribute(objid, attributeName, parentType);
  if channels is not None and len(channels) > 0:
    for channel in channels:
      if len(channel) > 0:
        if channel.find("#TransportChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "TransportChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, _export(channel, currespath, 'TransportChannel%s' % counterTransportChannel));
          counterTransportChannel = counterTransportChannel + 1;
        elif channel.find("#InboundTransportChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "InboundTransportChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, InboundTransportChannel._export(channel, currespath));
        elif channel.find("#OutboundTransportChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "OutboundTransportChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, OutboundTransportChannel._export(channel, currespath));
        elif channel.find("#TCPInboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "TCPInboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, TCPInboundChannel._export(channel, currespath));
        elif channel.find("#JFAPInboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "JFAPInboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, JFAPInboundChannel._export(channel, currespath));
        elif channel.find("#HTTPInboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "HTTPInboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, HTTPInboundChannel._export(channel, currespath));
        elif channel.find("#MQFAPInboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "MQFAPInboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, MQFAPInboundChannel._export(channel, currespath));
        elif channel.find("#WebContainerInboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "WebContainerInboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, WebContainerInboundChannel._export(channel, currespath));
        elif channel.find("#SSLInboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "SSLInboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, SSLInboundChannel._export(channel, currespath));
        elif channel.find("#HTTPTunnelInboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "HTTPTunnelInboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, HTTPTunnelInboundChannel._export(channel, currespath));
        elif channel.find("#TCPOutboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "TCPOutboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, TCPOutboundChannel._export(channel, currespath));
        elif channel.find("#HTTPOutboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "HTTPOutboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, HTTPOutboundChannel._export(channel, currespath));
        elif channel.find("#HTTPTunnelOutboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "HTTPTunnelOutboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, HTTPTunnelOutboundChannel._export(channel, currespath));
        elif channel.find("#SSLOutboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "SSLOutboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, SSLOutboundChannel._export(channel, currespath));
        elif channel.find("#JFAPOutboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "JFAPOutboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, JFAPOutboundChannel._export(channel, currespath));
        elif channel.find("#MQFAPOutboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "MQFAPOutboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, MQFAPOutboundChannel._export(channel, currespath));
        elif channel.find("#DCSInboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "DCSInboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, DCSInboundChannel._export(channel, currespath));
        elif channel.find("#GenericInboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "GenericInboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, GenericInboundChannel._export(channel, currespath));
        elif channel.find("#GenericOutboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "GenericOutboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, GenericOutboundChannel._export(channel, currespath));
        elif channel.find("#SIPInboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "SIPInboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, SIPInboundChannel._export(channel, currespath));
        elif channel.find("#SIPContainerInboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "SIPContainerInboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, SIPContainerInboundChannel._export(channel, currespath));
        elif channel.find("#UDPInboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "UDPInboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, UDPInboundChannel._export(channel, currespath));
        elif channel.find("#SIPProxyInboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "SIPProxyInboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, SIPProxyInboundChannel._export(channel, currespath));
        elif channel.find("#SIPOutboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "SIPOutboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, SIPOutboundChannel._export(channel, currespath));
        elif channel.find("#UDPOutboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "UDPOutboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, UDPOutboundChannel._export(channel, currespath));
        elif channel.find("#ORBInboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "ORBInboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, ORBInboundChannel._export(channel, currespath));
        elif channel.find("#HTTPQueueInboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "HTTPQueueInboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, HTTPQueueInboundChannel._export(channel, currespath));
        elif channel.find("#DataPowerMgrInboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "DataPowerMgrInboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, DataPowerMgrInboundChannel._export(channel, currespath));
        elif channel.find("#ProxyInboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "ProxyInboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, ProxyInboundChannel._export(channel, currespath));
        elif channel.find("#RMQOutboundChannel_") != -1:
          returndict = Util.createTypeFolder(respath, "RMQOutboundChannel", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, RMQOutboundChannel._export(channel, currespath));

  return extraObjects;

def createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath):
  if currole == "WebSphereTransportChannel":
    return create(objid, curjsonobject);
  elif currole == "WebSphereInboundTransportChannel":
    return InboundTransportChannel.create(objid, curjsonobject);
  elif currole == "WebSphereOutboundTransportChannel":
    return OutboundTransportChannel.create(objid, curjsonobject);
  elif currole == "WebSphereTCPInboundChannel":
    return TCPInboundChannel.create(objid, curjsonobject, threadPoolLookupPath);
  elif currole == "WebSphereJFAPInboundChannel":
    return JFAPInboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereHTTPInboundChannel":
    return HTTPInboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereMQFAPInboundChannel":
    return MQFAPInboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereWebContainerInboundChannel":
    return WebContainerInboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereSSLInboundChannel":
    return SSLInboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereHTTPTunnelInboundChannel":
    return HTTPTunnelInboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereTCPOutboundChannel":
    return TCPOutboundChannel.create(objid, curjsonobject, threadPoolLookupPath);
  elif currole == "WebSphereHTTPOutboundChannel":
    return HTTPOutboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereHTTPTunnelOutboundChannel":
    return HTTPTunnelOutboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereSSLOutboundChannel":
    return SSLOutboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereJFAPOutboundChannel":
    return JFAPOutboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereMQFAPOutboundChannel":
    return MQFAPOutboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereDCSInboundChannel":
    return DCSInboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereGenericInboundChannel":
    return GenericInboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereGenericOutboundChannel":
    return GenericOutboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereSIPInboundChannel":
    return SIPInboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereSIPContainerInboundChannel":
    return SIPContainerInboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereUDPInboundChannel":
    return UDPInboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereSIPProxyInboundChannel":
    return SIPProxyInboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereSIPOutboundChannel":
    return SIPOutboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereUDPOutboundChannel":
    return UDPOutboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereORBInboundChannel":
    return ORBInboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereHTTPQueueInboundChannel":
    return HTTPQueueInboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereDataPowerMgrInboundChannel":
    return DataPowerMgrInboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereProxyInboundChannel":
    return ProxyInboundChannel.create(objid, curjsonobject);
  elif currole == "WebSphereRMQOutboundChannel":
    return RMQOutboundChannel.create(objid, curjsonobject);
  return None;

