from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASPortComponentRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASPortComponentRef");
  exportedObject.put("roleName", "WebSphereWASPortComponentRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasportcomponentref.portcomponentlink", objid, "portComponentLink","WASPortComponentRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasportcomponentref.mtomthreshold", objid, "mtomThreshold","WASPortComponentRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasportcomponentref.serviceendpointinterface", objid, "serviceEndpointInterface","WASPortComponentRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasportcomponentref.enablemtom", objid, "enableMtom","WASPortComponentRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASPortComponentRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASPortComponentRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASPortComponentRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "portComponentLink", roleProperties.optString("websphere.wasportcomponentref.portcomponentlink", None));
  Util.addIfNotNone(properties, "mtomThreshold", roleProperties.optString("websphere.wasportcomponentref.mtomthreshold", None));
  Util.addIfNotNone(properties, "serviceEndpointInterface", roleProperties.optString("websphere.wasportcomponentref.serviceendpointinterface", None));
  Util.addIfNotNone(properties, "enableMtom", roleProperties.optString("websphere.wasportcomponentref.enablemtom", None));
  print "Creating WASPortComponentRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASPortComponentRef", parentid, properties);
  Util.popPathElement('WASPortComponentRef');

def update(objid,jsonobject):
  Util.pushPathElement('WASPortComponentRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASPortComponentRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasportcomponentref.portcomponentlink", None), "portComponentLink","WASPortComponentRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasportcomponentref.mtomthreshold", None), "mtomThreshold","WASPortComponentRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasportcomponentref.serviceendpointinterface", None), "serviceEndpointInterface","WASPortComponentRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasportcomponentref.enablemtom", None), "enableMtom","WASPortComponentRef");
  if len(atts) != 0:
    print "Modifying WASPortComponentRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASPortComponentRef configuration up to date.";

  Util.popPathElement('WASPortComponentRef');
