from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASResourceEnvRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASResourceEnvRef");
  exportedObject.put("roleName", "WebSphereWASResourceEnvRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasresourceenvref.type", objid, "type","WASResourceEnvRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasresourceenvref.mappedname", objid, "mappedName","WASResourceEnvRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasresourceenvref.lookupname", objid, "lookupName","WASResourceEnvRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasresourceenvref.refname", objid, "refName","WASResourceEnvRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASResourceEnvRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASResourceEnvRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASResourceEnvRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.wasresourceenvref.type", None));
  Util.addIfNotNone(properties, "mappedName", roleProperties.optString("websphere.wasresourceenvref.mappedname", None));
  Util.addIfNotNone(properties, "lookupName", roleProperties.optString("websphere.wasresourceenvref.lookupname", None));
  Util.addIfNotNone(properties, "refName", roleProperties.optString("websphere.wasresourceenvref.refname", None));
  print "Creating WASResourceEnvRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASResourceEnvRef", parentid, properties);
  Util.popPathElement('WASResourceEnvRef');

def update(objid,jsonobject):
  Util.pushPathElement('WASResourceEnvRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASResourceEnvRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasresourceenvref.type", None), "type","WASResourceEnvRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasresourceenvref.mappedname", None), "mappedName","WASResourceEnvRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasresourceenvref.lookupname", None), "lookupName","WASResourceEnvRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasresourceenvref.refname", None), "refName","WASResourceEnvRef");
  if len(atts) != 0:
    print "Modifying WASResourceEnvRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASResourceEnvRef configuration up to date.";

  Util.popPathElement('WASResourceEnvRef');
