from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WeightAdvisor')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWeightAdvisor");
  exportedObject.put("roleName", "WebSphereWeightAdvisor");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.weightadvisor.advisortype", objid, "advisorType","WeightAdvisor");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WeightAdvisor');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WeightAdvisor')
  if not jsonobject.has("roleProperties"):
    raise Exception("WeightAdvisor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "advisorType", roleProperties.optString("websphere.weightadvisor.advisortype", None));
  print "Creating WeightAdvisor with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WeightAdvisor", parentid, properties);
  Util.popPathElement('WeightAdvisor');

def update(objid,jsonobject):
  Util.pushPathElement('WeightAdvisor')
  if not jsonobject.has("roleProperties"):
    raise Exception("WeightAdvisor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.weightadvisor.advisortype", None), "advisorType","WeightAdvisor");
  if len(atts) != 0:
    print "Modifying WeightAdvisor with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WeightAdvisor configuration up to date.";

  Util.popPathElement('WeightAdvisor');
