from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('com.ibm.etools.webservice.wscext.DefaultMapping')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherecom.ibm.etools.webservice.wscext.DefaultMapping");
  exportedObject.put("roleName", "WebSpherecom.ibm.etools.webservice.wscext.DefaultMapping");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscext.defaultmapping.portlocalname", objid, "portLocalName","com.ibm.etools.webservice.wscext.DefaultMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscext.defaultmapping.porttypelocalname", objid, "portTypeLocalName","com.ibm.etools.webservice.wscext.DefaultMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscext.defaultmapping.portnamespace", objid, "portNamespace","com.ibm.etools.webservice.wscext.DefaultMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscext.defaultmapping.porttypenamespace", objid, "portTypeNamespace","com.ibm.etools.webservice.wscext.DefaultMapping");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('com.ibm.etools.webservice.wscext.DefaultMapping');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscext.DefaultMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscext.DefaultMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "portLocalName", roleProperties.optString("websphere.com.ibm.etools.webservice.wscext.defaultmapping.portlocalname", None));
  Util.addIfNotNone(properties, "portTypeLocalName", roleProperties.optString("websphere.com.ibm.etools.webservice.wscext.defaultmapping.porttypelocalname", None));
  Util.addIfNotNone(properties, "portNamespace", roleProperties.optString("websphere.com.ibm.etools.webservice.wscext.defaultmapping.portnamespace", None));
  Util.addIfNotNone(properties, "portTypeNamespace", roleProperties.optString("websphere.com.ibm.etools.webservice.wscext.defaultmapping.porttypenamespace", None));
  print "Creating com.ibm.etools.webservice.wscext.DefaultMapping with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("com.ibm.etools.webservice.wscext.DefaultMapping", parentid, properties);
  Util.popPathElement('com.ibm.etools.webservice.wscext.DefaultMapping');

def update(objid,jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscext.DefaultMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscext.DefaultMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscext.defaultmapping.portlocalname", None), "portLocalName","com.ibm.etools.webservice.wscext.DefaultMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscext.defaultmapping.porttypelocalname", None), "portTypeLocalName","com.ibm.etools.webservice.wscext.DefaultMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscext.defaultmapping.portnamespace", None), "portNamespace","com.ibm.etools.webservice.wscext.DefaultMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscext.defaultmapping.porttypenamespace", None), "portTypeNamespace","com.ibm.etools.webservice.wscext.DefaultMapping");
  if len(atts) != 0:
    print "Modifying com.ibm.etools.webservice.wscext.DefaultMapping with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "com.ibm.etools.webservice.wscext.DefaultMapping configuration up to date.";

  Util.popPathElement('com.ibm.etools.webservice.wscext.DefaultMapping');
