from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ErrorMapping')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereErrorMapping");
  exportedObject.put("roleName", "WebSphereErrorMapping");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.errormapping.url", objid, "URL","ErrorMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.errormapping.statuscode", objid, "statusCode","ErrorMapping");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ErrorMapping');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ErrorMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("ErrorMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "URL", roleProperties.optString("websphere.errormapping.url", None));
  Util.addIfNotNone(properties, "statusCode", roleProperties.optString("websphere.errormapping.statuscode", None));
  print "Creating ErrorMapping with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ErrorMapping", parentid, properties);
  Util.popPathElement('ErrorMapping');

def update(objid,jsonobject):
  Util.pushPathElement('ErrorMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("ErrorMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.errormapping.url", None), "URL","ErrorMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.errormapping.statuscode", None), "statusCode","ErrorMapping");
  if len(atts) != 0:
    print "Modifying ErrorMapping with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ErrorMapping configuration up to date.";

  Util.popPathElement('ErrorMapping');
