from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBBootstrapMember')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBBootstrapMember");
  exportedObject.put("roleName", "WebSphereSIBBootstrapMember");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibbootstrapmember.cluster", objid, "cluster","SIBBootstrapMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibbootstrapmember.node", objid, "node","SIBBootstrapMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibbootstrapmember.server", objid, "server","SIBBootstrapMember");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBBootstrapMember');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBBootstrapMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBBootstrapMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "cluster", roleProperties.optString("websphere.sibbootstrapmember.cluster", None));
  Util.addIfNotNone(properties, "node", roleProperties.optString("websphere.sibbootstrapmember.node", None));
  Util.addIfNotNone(properties, "server", roleProperties.optString("websphere.sibbootstrapmember.server", None));
  print "Creating SIBBootstrapMember with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBBootstrapMember", parentid, properties);
  Util.popPathElement('SIBBootstrapMember');

def update(objid,jsonobject):
  Util.pushPathElement('SIBBootstrapMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBBootstrapMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibbootstrapmember.cluster", None), "cluster","SIBBootstrapMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibbootstrapmember.node", None), "node","SIBBootstrapMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibbootstrapmember.server", None), "server","SIBBootstrapMember");
  if len(atts) != 0:
    print "Modifying SIBBootstrapMember with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBBootstrapMember configuration up to date.";

  Util.popPathElement('SIBBootstrapMember');
