from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBJMSTopic')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBJMSTopic");
  exportedObject.put("roleName", "WebSphereSIBJMSTopic");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopic.name", objid, "name","SIBJMSTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopic.topicname", objid, "topicName","SIBJMSTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopic.category", objid, "category","SIBJMSTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopic.providertype", objid, "providerType","SIBJMSTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopic.jndiname", objid, "jndiName","SIBJMSTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopic.readahead", objid, "readAhead","SIBJMSTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopic.topicspace", objid, "topicSpace","SIBJMSTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopic.nonpersistentmapping", objid, "nonPersistentMapping","SIBJMSTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopic.priority", objid, "priority","SIBJMSTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopic.deliverymode", objid, "deliveryMode","SIBJMSTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopic.description", objid, "description","SIBJMSTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopic.timetolive", objid, "timeToLive","SIBJMSTopic");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBJMSTopic');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBJMSTopic')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBJMSTopic resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibjmstopic.name", None));
  Util.addIfNotNone(properties, "topicName", roleProperties.optString("websphere.sibjmstopic.topicname", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.sibjmstopic.category", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.sibjmstopic.providertype", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.sibjmstopic.jndiname", None));
  Util.addIfNotNone(properties, "readAhead", roleProperties.optString("websphere.sibjmstopic.readahead", None));
  Util.addIfNotNone(properties, "topicSpace", roleProperties.optString("websphere.sibjmstopic.topicspace", None));
  Util.addIfNotNone(properties, "nonPersistentMapping", roleProperties.optString("websphere.sibjmstopic.nonpersistentmapping", None));
  Util.addIfNotNone(properties, "priority", roleProperties.optString("websphere.sibjmstopic.priority", None));
  Util.addIfNotNone(properties, "deliveryMode", roleProperties.optString("websphere.sibjmstopic.deliverymode", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibjmstopic.description", None));
  Util.addIfNotNone(properties, "timeToLive", roleProperties.optString("websphere.sibjmstopic.timetolive", None));
  print "Creating SIBJMSTopic with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBJMSTopic", parentid, properties);
  Util.popPathElement('SIBJMSTopic');

def update(objid,jsonobject):
  Util.pushPathElement('SIBJMSTopic')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBJMSTopic resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopic.name", None), "name","SIBJMSTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopic.topicname", None), "topicName","SIBJMSTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopic.category", None), "category","SIBJMSTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopic.providertype", None), "providerType","SIBJMSTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopic.jndiname", None), "jndiName","SIBJMSTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopic.readahead", None), "readAhead","SIBJMSTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopic.topicspace", None), "topicSpace","SIBJMSTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopic.nonpersistentmapping", None), "nonPersistentMapping","SIBJMSTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopic.priority", None), "priority","SIBJMSTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopic.deliverymode", None), "deliveryMode","SIBJMSTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopic.description", None), "description","SIBJMSTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopic.timetolive", None), "timeToLive","SIBJMSTopic");
  if len(atts) != 0:
    print "Modifying SIBJMSTopic with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBJMSTopic configuration up to date.";

  Util.popPathElement('SIBJMSTopic');
