from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SecureSessionCookie')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSecureSessionCookie");
  exportedObject.put("roleName", "WebSphereSecureSessionCookie");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securesessioncookie.cookiedomain", objid, "cookieDomain","SecureSessionCookie");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securesessioncookie.cookiepath", objid, "cookiePath","SecureSessionCookie");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securesessioncookie.cookiename", objid, "cookieName","SecureSessionCookie");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SecureSessionCookie');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SecureSessionCookie')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecureSessionCookie resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "cookieDomain", roleProperties.optString("websphere.securesessioncookie.cookiedomain", None));
  Util.addIfNotNone(properties, "cookiePath", roleProperties.optString("websphere.securesessioncookie.cookiepath", None));
  Util.addIfNotNone(properties, "cookieName", roleProperties.optString("websphere.securesessioncookie.cookiename", None));
  print "Creating SecureSessionCookie with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SecureSessionCookie", parentid, properties);
  Util.popPathElement('SecureSessionCookie');

def update(objid,jsonobject):
  Util.pushPathElement('SecureSessionCookie')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecureSessionCookie resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securesessioncookie.cookiedomain", None), "cookieDomain","SecureSessionCookie");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securesessioncookie.cookiepath", None), "cookiePath","SecureSessionCookie");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securesessioncookie.cookiename", None), "cookieName","SecureSessionCookie");
  if len(atts) != 0:
    print "Modifying SecureSessionCookie with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SecureSessionCookie configuration up to date.";

  Util.popPathElement('SecureSessionCookie');
