from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SubjectExt')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSubjectExt");
  exportedObject.put("roleName", "WebSphereSubjectExt");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.subjectext.name", objid, "name","SubjectExt");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.subjectext.accessid", objid, "accessId","SubjectExt");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SubjectExt');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SubjectExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("SubjectExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.subjectext.name", None));
  Util.addIfNotNone(properties, "accessId", roleProperties.optString("websphere.subjectext.accessid", None));
  print "Creating SubjectExt with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SubjectExt", parentid, properties);
  Util.popPathElement('SubjectExt');

def update(objid,jsonobject):
  Util.pushPathElement('SubjectExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("SubjectExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.subjectext.name", None), "name","SubjectExt");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.subjectext.accessid", None), "accessId","SubjectExt");
  if len(atts) != 0:
    print "Modifying SubjectExt with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SubjectExt configuration up to date.";

  Util.popPathElement('SubjectExt');
