from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASPersistenceContextRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASPersistenceContextRef");
  exportedObject.put("roleName", "WebSphereWASPersistenceContextRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.waspersistencecontextref.persistencecontexttype", objid, "persistenceContextType","WASPersistenceContextRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.waspersistencecontextref.mappedname", objid, "mappedName","WASPersistenceContextRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.waspersistencecontextref.persistenceunitname", objid, "persistenceUnitName","WASPersistenceContextRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.waspersistencecontextref.refname", objid, "refName","WASPersistenceContextRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"WASPersistenceContextRef");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASPersistenceContextRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASPersistenceContextRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASPersistenceContextRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "persistenceContextType", roleProperties.optString("websphere.waspersistencecontextref.persistencecontexttype", None));
  Util.addIfNotNone(properties, "mappedName", roleProperties.optString("websphere.waspersistencecontextref.mappedname", None));
  Util.addIfNotNone(properties, "persistenceUnitName", roleProperties.optString("websphere.waspersistencecontextref.persistenceunitname", None));
  Util.addIfNotNone(properties, "refName", roleProperties.optString("websphere.waspersistencecontextref.refname", None));
  print "Creating WASPersistenceContextRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASPersistenceContextRef", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WASPersistenceContextRef');

def update(objid,jsonobject):
  Util.pushPathElement('WASPersistenceContextRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASPersistenceContextRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.waspersistencecontextref.persistencecontexttype", None), "persistenceContextType","WASPersistenceContextRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.waspersistencecontextref.mappedname", None), "mappedName","WASPersistenceContextRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.waspersistencecontextref.persistenceunitname", None), "persistenceUnitName","WASPersistenceContextRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.waspersistencecontextref.refname", None), "refName","WASPersistenceContextRef");
  if len(atts) != 0:
    print "Modifying WASPersistenceContextRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASPersistenceContextRef configuration up to date.";

  Property.removeProperties(objid, 'properties',"WASPersistenceContextRef");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WASPersistenceContextRef');
