from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.wasqueue.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'WASQueue');

  containmentpath = "%(parentconpath)sWASQueue:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('WASQueue')

  name = Util.getRequiredAttribute(objid, "name", 'WASQueue');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASQueue");
  exportedObject.put("roleName", "WebSphereWASQueue");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasqueue.name", objid, "name","WASQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasqueue.category", objid, "category","WASQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasqueue.node", objid, "node","WASQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasqueue.expiry", objid, "expiry","WASQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasqueue.providertype", objid, "providerType","WASQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasqueue.jndiname", objid, "jndiName","WASQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasqueue.specifiedpriority", objid, "specifiedPriority","WASQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasqueue.specifiedexpiry", objid, "specifiedExpiry","WASQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasqueue.persistence", objid, "persistence","WASQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasqueue.priority", objid, "priority","WASQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasqueue.description", objid, "description","WASQueue");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASQueue');
  return result;

def doImportPartial(containmentpath, roleName, jsonobject):
  doImport(containmentpath, roleName, jsonobject);

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("WASQueue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.wasqueue.name"):
    raise Exception("Resource role properties does not contain websphere.wasqueue.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    if Util.__removePartialConfig__ == "false":
      index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
      parentconpath = containmentpath[0:index];
      parentid = Util.getid(parentconpath);
      if parentid == None or len(parentid) == 0:
        raise Exception("Parent does not exist to create WASQueue on.");
      objid = create(parentid, jsonobject);
  else:
    if Util.__removePartialConfig__ == "true":
      Util.removePartialApply(objid);
      objid = None;
    else:
      update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('WASQueue')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASQueue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.wasqueue.name"):
    raise Exception("Resource role properties does not contain websphere.wasqueue.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.wasqueue.name", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.wasqueue.category", None));
  Util.addIfNotNone(properties, "node", roleProperties.optString("websphere.wasqueue.node", None));
  Util.addIfNotNone(properties, "expiry", roleProperties.optString("websphere.wasqueue.expiry", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.wasqueue.providertype", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.wasqueue.jndiname", None));
  Util.addIfNotNone(properties, "specifiedPriority", roleProperties.optString("websphere.wasqueue.specifiedpriority", None));
  Util.addIfNotNone(properties, "specifiedExpiry", roleProperties.optString("websphere.wasqueue.specifiedexpiry", None));
  Util.addIfNotNone(properties, "persistence", roleProperties.optString("websphere.wasqueue.persistence", None));
  Util.addIfNotNone(properties, "priority", roleProperties.optString("websphere.wasqueue.priority", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.wasqueue.description", None));
  print "Creating WASQueue with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASQueue", parentid, properties);
  Util.popPathElement('WASQueue');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('WASQueue')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASQueue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.wasqueue.name"):
    raise Exception("Resource role properties does not contain websphere.wasqueue.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasqueue.name", None), "name","WASQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasqueue.category", None), "category","WASQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasqueue.node", None), "node","WASQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasqueue.expiry", None), "expiry","WASQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasqueue.providertype", None), "providerType","WASQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasqueue.jndiname", None), "jndiName","WASQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasqueue.specifiedpriority", None), "specifiedPriority","WASQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasqueue.specifiedexpiry", None), "specifiedExpiry","WASQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasqueue.persistence", None), "persistence","WASQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasqueue.priority", None), "priority","WASQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasqueue.description", None), "description","WASQueue");
  if len(atts) != 0:
    print "Modifying WASQueue with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASQueue configuration up to date.";

  Util.popPathElement('WASQueue');
