from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Commsvc')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCommsvc");
  exportedObject.put("roleName", "WebSphereCommsvc");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.commsvc.maxrequestholdtime", objid, "maxRequestHoldTime","Commsvc");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.commsvc.thirdpartywsdlprovider", objid, "thirdPartyWSDLProvider","Commsvc");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"Commsvc");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Commsvc');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Commsvc')
  if not jsonobject.has("roleProperties"):
    raise Exception("Commsvc resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "maxRequestHoldTime", roleProperties.optString("websphere.commsvc.maxrequestholdtime", None));
  Util.addIfNotNone(properties, "thirdPartyWSDLProvider", roleProperties.optString("websphere.commsvc.thirdpartywsdlprovider", None));
  print "Creating Commsvc with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Commsvc", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('Commsvc');

def update(objid,jsonobject):
  Util.pushPathElement('Commsvc')
  if not jsonobject.has("roleProperties"):
    raise Exception("Commsvc resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.commsvc.maxrequestholdtime", None), "maxRequestHoldTime","Commsvc");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.commsvc.thirdpartywsdlprovider", None), "thirdPartyWSDLProvider","Commsvc");
  if len(atts) != 0:
    print "Modifying Commsvc with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Commsvc configuration up to date.";

  Property.removeProperties(objid, 'properties',"Commsvc");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('Commsvc');
