from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('JobManagerRegistration')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJobManagerRegistration");
  exportedObject.put("roleName", "WebSphereJobManagerRegistration");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobmanagerregistration.registeredname", objid, "registeredName","JobManagerRegistration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobmanagerregistration.url", objid, "URL","JobManagerRegistration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobmanagerregistration.port", objid, "port","JobManagerRegistration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobmanagerregistration.conntype", objid, "connType","JobManagerRegistration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobmanagerregistration.host", objid, "host","JobManagerRegistration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobmanagerregistration.pollingenabled", objid, "pollingEnabled","JobManagerRegistration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobmanagerregistration.pollinginterval", objid, "pollingInterval","JobManagerRegistration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobmanagerregistration.jobmanageruuid", objid, "jobManagerUUID","JobManagerRegistration");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JobManagerRegistration');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('JobManagerRegistration')
  if not jsonobject.has("roleProperties"):
    raise Exception("JobManagerRegistration resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "registeredName", roleProperties.optString("websphere.jobmanagerregistration.registeredname", None));
  Util.addIfNotNone(properties, "URL", roleProperties.optString("websphere.jobmanagerregistration.url", None));
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.jobmanagerregistration.port", None));
  Util.addIfNotNone(properties, "connType", roleProperties.optString("websphere.jobmanagerregistration.conntype", None));
  Util.addIfNotNone(properties, "host", roleProperties.optString("websphere.jobmanagerregistration.host", None));
  Util.addIfNotNone(properties, "pollingEnabled", roleProperties.optString("websphere.jobmanagerregistration.pollingenabled", None));
  Util.addIfNotNone(properties, "pollingInterval", roleProperties.optString("websphere.jobmanagerregistration.pollinginterval", None));
  Util.addIfNotNone(properties, "jobManagerUUID", roleProperties.optString("websphere.jobmanagerregistration.jobmanageruuid", None));
  print "Creating JobManagerRegistration with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JobManagerRegistration", parentid, properties);
  Util.popPathElement('JobManagerRegistration');

def update(objid,jsonobject):
  Util.pushPathElement('JobManagerRegistration')
  if not jsonobject.has("roleProperties"):
    raise Exception("JobManagerRegistration resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobmanagerregistration.registeredname", None), "registeredName","JobManagerRegistration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobmanagerregistration.url", None), "URL","JobManagerRegistration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobmanagerregistration.port", None), "port","JobManagerRegistration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobmanagerregistration.conntype", None), "connType","JobManagerRegistration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobmanagerregistration.host", None), "host","JobManagerRegistration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobmanagerregistration.pollingenabled", None), "pollingEnabled","JobManagerRegistration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobmanagerregistration.pollinginterval", None), "pollingInterval","JobManagerRegistration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobmanagerregistration.jobmanageruuid", None), "jobManagerUUID","JobManagerRegistration");
  if len(atts) != 0:
    print "Modifying JobManagerRegistration with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JobManagerRegistration configuration up to date.";

  Util.popPathElement('JobManagerRegistration');
