from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SecurityProtocolQOP')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSecurityProtocolQOP");
  exportedObject.put("roleName", "WebSphereSecurityProtocolQOP");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securityprotocolqop.establishtrustinclient", objid, "establishTrustInClient","SecurityProtocolQOP");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securityprotocolqop.enableprotection", objid, "enableProtection","SecurityProtocolQOP");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securityprotocolqop.enablereplaydetection", objid, "enableReplayDetection","SecurityProtocolQOP");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securityprotocolqop.enableoutofsequencedetection", objid, "enableOutOfSequenceDetection","SecurityProtocolQOP");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SecurityProtocolQOP');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SecurityProtocolQOP')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecurityProtocolQOP resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "establishTrustInClient", roleProperties.optString("websphere.securityprotocolqop.establishtrustinclient", None));
  Util.addIfNotNone(properties, "enableProtection", roleProperties.optString("websphere.securityprotocolqop.enableprotection", None));
  Util.addIfNotNone(properties, "enableReplayDetection", roleProperties.optString("websphere.securityprotocolqop.enablereplaydetection", None));
  Util.addIfNotNone(properties, "enableOutOfSequenceDetection", roleProperties.optString("websphere.securityprotocolqop.enableoutofsequencedetection", None));
  print "Creating SecurityProtocolQOP with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SecurityProtocolQOP", parentid, properties);
  Util.popPathElement('SecurityProtocolQOP');

def update(objid,jsonobject):
  Util.pushPathElement('SecurityProtocolQOP')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecurityProtocolQOP resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securityprotocolqop.establishtrustinclient", None), "establishTrustInClient","SecurityProtocolQOP");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securityprotocolqop.enableprotection", None), "enableProtection","SecurityProtocolQOP");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securityprotocolqop.enablereplaydetection", None), "enableReplayDetection","SecurityProtocolQOP");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securityprotocolqop.enableoutofsequencedetection", None), "enableOutOfSequenceDetection","SecurityProtocolQOP");
  if len(atts) != 0:
    print "Modifying SecurityProtocolQOP with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SecurityProtocolQOP configuration up to date.";

  Util.popPathElement('SecurityProtocolQOP');
