from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('com.ibm.etools.webservice.wsbnd.PCBinding')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherecom.ibm.etools.webservice.wsbnd.PCBinding");
  exportedObject.put("roleName", "WebSpherecom.ibm.etools.webservice.wsbnd.PCBinding");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wsbnd.pcbinding.pcnamelink", objid, "pcNameLink","com.ibm.etools.webservice.wsbnd.PCBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wsbnd.pcbinding.wsdlserviceqnamelocalnamelink", objid, "wsdlServiceQnameLocalnameLink","com.ibm.etools.webservice.wsbnd.PCBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wsbnd.pcbinding.scope", objid, "scope","com.ibm.etools.webservice.wsbnd.PCBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wsbnd.pcbinding.wsdlserviceqnamenamespacelink", objid, "wsdlServiceQnameNamespaceLink","com.ibm.etools.webservice.wsbnd.PCBinding");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('com.ibm.etools.webservice.wsbnd.PCBinding');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wsbnd.PCBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wsbnd.PCBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "pcNameLink", roleProperties.optString("websphere.com.ibm.etools.webservice.wsbnd.pcbinding.pcnamelink", None));
  Util.addIfNotNone(properties, "wsdlServiceQnameLocalnameLink", roleProperties.optString("websphere.com.ibm.etools.webservice.wsbnd.pcbinding.wsdlserviceqnamelocalnamelink", None));
  Util.addIfNotNone(properties, "scope", roleProperties.optString("websphere.com.ibm.etools.webservice.wsbnd.pcbinding.scope", None));
  Util.addIfNotNone(properties, "wsdlServiceQnameNamespaceLink", roleProperties.optString("websphere.com.ibm.etools.webservice.wsbnd.pcbinding.wsdlserviceqnamenamespacelink", None));
  print "Creating com.ibm.etools.webservice.wsbnd.PCBinding with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("com.ibm.etools.webservice.wsbnd.PCBinding", parentid, properties);
  Util.popPathElement('com.ibm.etools.webservice.wsbnd.PCBinding');

def update(objid,jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wsbnd.PCBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wsbnd.PCBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wsbnd.pcbinding.pcnamelink", None), "pcNameLink","com.ibm.etools.webservice.wsbnd.PCBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wsbnd.pcbinding.wsdlserviceqnamelocalnamelink", None), "wsdlServiceQnameLocalnameLink","com.ibm.etools.webservice.wsbnd.PCBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wsbnd.pcbinding.scope", None), "scope","com.ibm.etools.webservice.wsbnd.PCBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wsbnd.pcbinding.wsdlserviceqnamenamespacelink", None), "wsdlServiceQnameNamespaceLink","com.ibm.etools.webservice.wsbnd.PCBinding");
  if len(atts) != 0:
    print "Modifying com.ibm.etools.webservice.wsbnd.PCBinding with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "com.ibm.etools.webservice.wsbnd.PCBinding configuration up to date.";

  Util.popPathElement('com.ibm.etools.webservice.wsbnd.PCBinding');
