from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ApplicationServerEndpoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereApplicationServerEndpoint");
  exportedObject.put("roleName", "WebSphereApplicationServerEndpoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationserverendpoint.cellname", objid, "cellName","ApplicationServerEndpoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationserverendpoint.servername", objid, "serverName","ApplicationServerEndpoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationserverendpoint.nodename", objid, "nodeName","ApplicationServerEndpoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ApplicationServerEndpoint');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ApplicationServerEndpoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationServerEndpoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "cellName", roleProperties.optString("websphere.applicationserverendpoint.cellname", None));
  Util.addIfNotNone(properties, "serverName", roleProperties.optString("websphere.applicationserverendpoint.servername", None));
  Util.addIfNotNone(properties, "nodeName", roleProperties.optString("websphere.applicationserverendpoint.nodename", None));
  print "Creating ApplicationServerEndpoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ApplicationServerEndpoint", parentid, properties);
  Util.popPathElement('ApplicationServerEndpoint');

def update(objid,jsonobject):
  Util.pushPathElement('ApplicationServerEndpoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationServerEndpoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationserverendpoint.cellname", None), "cellName","ApplicationServerEndpoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationserverendpoint.servername", None), "serverName","ApplicationServerEndpoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationserverendpoint.nodename", None), "nodeName","ApplicationServerEndpoint");
  if len(atts) != 0:
    print "Modifying ApplicationServerEndpoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ApplicationServerEndpoint configuration up to date.";

  Util.popPathElement('ApplicationServerEndpoint');
