from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DataSourceDefinition')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDataSourceDefinition");
  exportedObject.put("roleName", "WebSphereDataSourceDefinition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasourcedefinition.initialpoolsize", objid, "initialPoolSize","DataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasourcedefinition.password", objid, "password","DataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasourcedefinition.portnumber", objid, "portNumber","DataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasourcedefinition.maxstatements", objid, "maxStatements","DataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasourcedefinition.url", objid, "url","DataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasourcedefinition.servername", objid, "serverName","DataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasourcedefinition.logintimeout", objid, "loginTimeout","DataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasourcedefinition.isolationlevel", objid, "isolationLevel","DataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasourcedefinition.minpoolsize", objid, "minPoolSize","DataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasourcedefinition.maxpoolsize", objid, "maxPoolSize","DataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasourcedefinition.description", objid, "description","DataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasourcedefinition.transactional", objid, "transactional","DataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasourcedefinition.databasename", objid, "databaseName","DataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasourcedefinition.maxidletime", objid, "maxIdleTime","DataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasourcedefinition.user", objid, "user","DataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.datasourcedefinition.name", objid, "name","DataSourceDefinition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"DataSourceDefinition");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DataSourceDefinition');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DataSourceDefinition')
  if not jsonobject.has("roleProperties"):
    raise Exception("DataSourceDefinition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "initialPoolSize", roleProperties.optString("websphere.datasourcedefinition.initialpoolsize", None));
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.datasourcedefinition.password", None));
  Util.addIfNotNone(properties, "portNumber", roleProperties.optString("websphere.datasourcedefinition.portnumber", None));
  Util.addIfNotNone(properties, "maxStatements", roleProperties.optString("websphere.datasourcedefinition.maxstatements", None));
  Util.addIfNotNone(properties, "url", roleProperties.optString("websphere.datasourcedefinition.url", None));
  Util.addIfNotNone(properties, "serverName", roleProperties.optString("websphere.datasourcedefinition.servername", None));
  Util.addIfNotNone(properties, "loginTimeout", roleProperties.optString("websphere.datasourcedefinition.logintimeout", None));
  Util.addIfNotNone(properties, "isolationLevel", roleProperties.optString("websphere.datasourcedefinition.isolationlevel", None));
  Util.addIfNotNone(properties, "minPoolSize", roleProperties.optString("websphere.datasourcedefinition.minpoolsize", None));
  Util.addIfNotNone(properties, "maxPoolSize", roleProperties.optString("websphere.datasourcedefinition.maxpoolsize", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.datasourcedefinition.description", None));
  Util.addIfNotNone(properties, "transactional", roleProperties.optString("websphere.datasourcedefinition.transactional", None));
  Util.addIfNotNone(properties, "databaseName", roleProperties.optString("websphere.datasourcedefinition.databasename", None));
  Util.addIfNotNone(properties, "maxIdleTime", roleProperties.optString("websphere.datasourcedefinition.maxidletime", None));
  Util.addIfNotNone(properties, "user", roleProperties.optString("websphere.datasourcedefinition.user", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.datasourcedefinition.name", None));
  print "Creating DataSourceDefinition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DataSourceDefinition", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DataSourceDefinition');

def update(objid,jsonobject):
  Util.pushPathElement('DataSourceDefinition')
  if not jsonobject.has("roleProperties"):
    raise Exception("DataSourceDefinition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasourcedefinition.initialpoolsize", None), "initialPoolSize","DataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasourcedefinition.password", None), "password","DataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasourcedefinition.portnumber", None), "portNumber","DataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasourcedefinition.maxstatements", None), "maxStatements","DataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasourcedefinition.url", None), "url","DataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasourcedefinition.servername", None), "serverName","DataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasourcedefinition.logintimeout", None), "loginTimeout","DataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasourcedefinition.isolationlevel", None), "isolationLevel","DataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasourcedefinition.minpoolsize", None), "minPoolSize","DataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasourcedefinition.maxpoolsize", None), "maxPoolSize","DataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasourcedefinition.description", None), "description","DataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasourcedefinition.transactional", None), "transactional","DataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasourcedefinition.databasename", None), "databaseName","DataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasourcedefinition.maxidletime", None), "maxIdleTime","DataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasourcedefinition.user", None), "user","DataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.datasourcedefinition.name", None), "name","DataSourceDefinition");
  if len(atts) != 0:
    print "Modifying DataSourceDefinition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DataSourceDefinition configuration up to date.";

  Property.removeProperties(objid, 'properties',"DataSourceDefinition");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DataSourceDefinition');
