from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from File import File

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('EARFile')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEARFile");
  exportedObject.put("roleName", "WebSphereEARFile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.earfile.lastmodified", objid, "lastModified","EARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.earfile.originaluri", objid, "originalURI","EARFile");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.earfile.types", objid, "types","EARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.earfile.directoryentry", objid, "directoryEntry","EARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.earfile.uri", objid, "URI","EARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.earfile.size", objid, "size","EARFile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = File.exportFiles(objid, respath, extraObjects, typeFolders, 'files', "EARFile");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EARFile');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('EARFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("EARFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "lastModified", roleProperties.optString("websphere.earfile.lastmodified", None));
  Util.addIfNotNone(properties, "originalURI", roleProperties.optString("websphere.earfile.originaluri", None));
  Util.addPathProperty(properties, "types", roleProperties.optString("websphere.earfile.types", None));
  Util.addIfNotNone(properties, "directoryEntry", roleProperties.optString("websphere.earfile.directoryentry", None));
  Util.addIfNotNone(properties, "URI", roleProperties.optString("websphere.earfile.uri", None));
  Util.addIfNotNone(properties, "size", roleProperties.optString("websphere.earfile.size", None));
  print "Creating EARFile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EARFile", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('EARFile');

def update(objid,jsonobject):
  Util.pushPathElement('EARFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("EARFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.earfile.lastmodified", None), "lastModified","EARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.earfile.originaluri", None), "originalURI","EARFile");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.earfile.types", None), "types","EARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.earfile.directoryentry", None), "directoryEntry","EARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.earfile.uri", None), "URI","EARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.earfile.size", None), "size","EARFile");
  if len(atts) != 0:
    print "Modifying EARFile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EARFile configuration up to date.";

  File.removeFiles(objid, 'files',"EARFile");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('EARFile');
