from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from DeploymentTargetMapping import DeploymentTargetMapping
from Property import Property
from Classloader import Classloader

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ModuleDeployment')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereModuleDeployment");
  exportedObject.put("roleName", "WebSphereModuleDeployment");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.moduledeployment.name", objid, "name","ModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.moduledeployment.startingweight", objid, "startingWeight","ModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.moduledeployment.uri", objid, "uri","ModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.moduledeployment.deploymentid", objid, "deploymentId","ModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.moduledeployment.altdd", objid, "altDD","ModuleDeployment");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ModuleDeployment");
  i = 0;
  targetmappings = Util.parseConfigIdListAttribute(objid, 'targetMappings',"ModuleDeployment");
  for targetmapping in targetmappings:
    if len(targetmapping) > 0:
      returndict = Util.createTypeFolder(respath, "DeploymentTargetMapping", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, DeploymentTargetMapping._export(targetmapping, currespath, "DeploymentTargetMapping%s" % i));
      i = i + 1;
      
  classloader = Util.getRequiredAttribute(objid, 'classloader',"ModuleDeployment");
  if classloader is not None and len(classloader) > 0:
    returndict = Util.createTypeFolder(respath, "Classloader", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, Classloader._export(classloader, currespath, "Classloader"));     
      
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ModuleDeployment');
  return result;

def create(parentid, jsonobject):
  Util.pushPathElement('ModuleDeployment')
  if not jsonobject.has("roleProperties"):
    raise Exception("ModuleDeployment resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.moduledeployment.name", ""));
  Util.addIfNotNone(properties, "startingWeight", roleProperties.optString("websphere.moduledeployment.startingweight", None));
  Util.addIfNotNone(properties, "uri", roleProperties.optString("websphere.moduledeployment.uri", None));
  Util.addIfNotNone(properties, "deploymentId", roleProperties.optString("websphere.moduledeployment.deploymentid", None));
  Util.addIfNotNone(properties, "altDD", roleProperties.optString("websphere.moduledeployment.altdd", None));
  print "Creating ModuleDeployment with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ModuleDeployment", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDeploymentTargetMapping":
        DeploymentTargetMapping.create(objid, curjsonobject);
      elif currole == "WebSphereClassloader":
        Classloader.create(objid, curjsonobject);    
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ModuleDeployment');

def update(objid,jsonobject):
  Util.pushPathElement('ModuleDeployment')
  if not jsonobject.has("roleProperties"):
    raise Exception("ModuleDeployment resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.moduledeployment.name", ""), "name","ModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.moduledeployment.startingweight", None), "startingWeight","ModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.moduledeployment.uri", None), "uri","ModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.moduledeployment.deploymentid", None), "deploymentId","ModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.moduledeployment.altdd", None), "altDD","ModuleDeployment");
  if len(atts) != 0:
    print "Modifying ModuleDeployment with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ModuleDeployment configuration up to date.";

  targetmappings = Util.parseConfigIdListAttribute(objid, 'targetMappings',"ModuleDeployment");
  for targetmapping in targetmappings:
    if len(targetmapping) > 0:
      Util.remove(targetmapping);

  classloader = Util.getRequiredAttribute(objid, 'classloader',"ModuleDeployment");
  if classloader is not None and len(classloader) > 0:
    Util.remove(classloader);     
      
  Property.removeProperties(objid, 'properties',"ModuleDeployment");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDeploymentTargetMapping":
        DeploymentTargetMapping.create(objid, curjsonobject);
      elif currole == "WebSphereClassloader":
        Classloader.create(objid, curjsonobject);    
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ModuleDeployment');
