from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from RoutingAction import RoutingAction
from HTTPRequestHeaderAction import HTTPRequestHeaderAction
from HTTPResponseHeaderAction import HTTPResponseHeaderAction
from HTTPRequestCompressionAction import HTTPRequestCompressionAction
from HTTPResponseCompressionAction import HTTPResponseCompressionAction
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ProxyAction')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereProxyAction");
  exportedObject.put("roleName", "WebSphereProxyAction");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyaction.name", objid, "name","ProxyAction");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ProxyAction");

  routingAction = Util.getOptionalAttribute(objid, 'routingAction', 'ProxyAction');
  if routingAction is not None and len(routingAction) > 0:
    returndict = Util.createTypeFolder(respath, "RoutingAction", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    routingActionName = Util.getOptionalAttribute(routingAction, "name", "RoutingAction");
    if routingActionName == None or len(routingActionName) == 0:
      routingActionName = ("Routing Action")
    Util.addAllFromExport(extraObjects, RoutingAction._export(routingAction, currespath, routingActionName));

  headerAction = Util.getOptionalAttribute(objid, 'headerAction',"ProxyAction");
  if headerAction is not None and len(headerAction) > 0:
    if headerAction.find("#HTTPRequestHeaderAction_") != -1:
      returndict = Util.createTypeFolder(respath, "HTTPRequestHeaderAction", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      httpRequestHeaderActionName = Util.getOptionalAttribute(headerAction, "name", "HTTPRequestHeaderAction");
      if httpRequestHeaderActionName == None or len(httpRequestHeaderActionName) == 0:
        httpRequestHeaderActionName = ("HTTP Request Header Action");
      Util.addAllFromExport(extraObjects, HTTPRequestHeaderAction._export(headerAction, currespath, httpRequestHeaderActionName));
    elif headerAction.find("#HTTPResponseHeaderAction_") != -1:
      returndict = Util.createTypeFolder(respath, "HTTPResponseHeaderAction", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      httpResponseHeaderActionName = Util.getOptionalAttribute(headerAction, "name", "HTTPResponseHeaderAction");
      if httpResponseHeaderActionName == None or len(httpResponseHeaderActionName) == 0:
        httpResponseHeaderActionName = ("HTTP Response Header Action");
      Util.addAllFromExport(extraObjects, HTTPResponseHeaderAction._export(headerAction, currespath, httpResponseHeaderActionName));

  httpCompressionAction = Util.getOptionalAttribute(objid, 'HTTPCompressionAction',"CompressionAction");
  if httpCompressionAction is not None and len(httpCompressionAction) > 0:
    if httpCompressionAction.find("#HTTPRequestCompressionAction_") != -1:
      returndict = Util.createTypeFolder(respath, "HTTPRequestCompressionAction", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      httpCompressionActionName = Util.getOptionalAttribute(httpCompressionAction, "name", "CompressionAction");
      if httpCompressionActionName == None or len(httpCompressionActionName) == 0:
        httpCompressionActionName = ("HTTP Request Compression Action")
      Util.addAllFromExport(extraObjects, HTTPRequestCompressionAction._export(httpCompressionAction, currespath, httpCompressionActionName));
    elif httpCompressionAction.find("#HTTPResponseCompressionAction_") != -1:
      returndict = Util.createTypeFolder(respath, "HTTPResponseCompressionAction", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      httpCompressionActionName = Util.getOptionalAttribute(httpCompressionAction, "name", "CompressionAction");
      if httpCompressionActionName == None or len(httpCompressionActionName) == 0:
        httpCompressionActionName = ("HTTP Response Compression Action")
      Util.addAllFromExport(extraObjects, HTTPResponseCompressionAction._export(httpCompressionAction, currespath, httpCompressionActionName));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ProxyAction');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ProxyAction')
  if not jsonobject.has("roleProperties"):
    raise Exception("ProxyAction resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.proxyaction.name", None));
  print "Creating ProxyAction with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ProxyAction", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereRoutingAction":
        RoutingAction.create(objid, curjsonobject);
      elif currole == "WebSphereHTTPRequestHeaderAction":
        HTTPRequestHeaderAction.create(objid, curjsonobject);
      elif currole == "WebSphereHTTPResponseHeaderAction":
        HTTPResponseHeaderAction.create(objid, curjsonobject);
      elif currole == "WebSphereHTTPRequestCompressionAction":
        HTTPRequestCompressionAction.create(objid, curjsonobject);
      elif currole == "WebSphereHTTPResponseCompressionAction":
        HTTPResponseCompressionAction.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ProxyAction');

def update(objid,jsonobject):
  Util.pushPathElement('ProxyAction')
  if not jsonobject.has("roleProperties"):
    raise Exception("ProxyAction resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyaction.name", None), "name","ProxyAction");
  if len(atts) != 0:
    print "Modifying ProxyAction with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ProxyAction configuration up to date.";

  routingAction = Util.getOptionalAttribute(objid, 'routingAction', 'ProxyAction');
  if routingAction is not None and len(routingAction) > 0:
    Util.remove(routingAction);

  headerAction = Util.getOptionalAttribute(objid, 'headerAction', 'CompressionAction');
  if headerAction is not None and len(headerAction) > 0:
    Util.remove(headerAction);

  httpCompressionAction = Util.getOptionalAttribute(objid, 'HTTPCompressionAction',"CompressionAction");
  if httpCompressionAction is not None and len(httpCompressionAction) > 0:
    Util.remove(httpCompressionAction);

  Property.removeProperties(objid, 'properties',"ProxyAction");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereRoutingAction":
        RoutingAction.create(objid, curjsonobject);
      elif currole == "WebSphereHTTPRequestHeaderAction":
        HTTPRequestHeaderAction.create(objid, curjsonobject);
      elif currole == "WebSphereHTTPResponseHeaderAction":
        HTTPResponseHeaderAction.create(objid, curjsonobject);
      elif currole == "WebSphereHTTPRequestCompressionAction":
        HTTPRequestCompressionAction.create(objid, curjsonobject);
      elif currole == "WebSphereHTTPResponseCompressionAction":
        HTTPResponseCompressionAction.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ProxyAction');
