from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBWMQServerSvrconnChannel')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBWMQServerSvrconnChannel");
  exportedObject.put("roleName", "WebSphereSIBWMQServerSvrconnChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwmqserversvrconnchannel.sendexitinit", objid, "sendExitInit","SIBWMQServerSvrconnChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwmqserversvrconnchannel.name", objid, "name","SIBWMQServerSvrconnChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwmqserversvrconnchannel.sslreset", objid, "sslReset","SIBWMQServerSvrconnChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwmqserversvrconnchannel.sslpeer", objid, "sslPeer","SIBWMQServerSvrconnChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwmqserversvrconnchannel.receiveexit", objid, "receiveExit","SIBWMQServerSvrconnChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwmqserversvrconnchannel.ssltype", objid, "sslType","SIBWMQServerSvrconnChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwmqserversvrconnchannel.securityexitinit", objid, "securityExitInit","SIBWMQServerSvrconnChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwmqserversvrconnchannel.sendexit", objid, "sendExit","SIBWMQServerSvrconnChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwmqserversvrconnchannel.receiveexitinit", objid, "receiveExitInit","SIBWMQServerSvrconnChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwmqserversvrconnchannel.sslendpoint", objid, "sslEndpoint","SIBWMQServerSvrconnChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwmqserversvrconnchannel.sslchain", objid, "sslChain","SIBWMQServerSvrconnChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwmqserversvrconnchannel.securityexit", objid, "securityExit","SIBWMQServerSvrconnChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwmqserversvrconnchannel.sslcrl", objid, "sslCRL","SIBWMQServerSvrconnChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBWMQServerSvrconnChannel');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBWMQServerSvrconnChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWMQServerSvrconnChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "sendExitInit", roleProperties.optString("websphere.sibwmqserversvrconnchannel.sendexitinit", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibwmqserversvrconnchannel.name", None));
  Util.addIfNotNone(properties, "sslReset", roleProperties.optString("websphere.sibwmqserversvrconnchannel.sslreset", None));
  Util.addIfNotNone(properties, "sslPeer", roleProperties.optString("websphere.sibwmqserversvrconnchannel.sslpeer", None));
  Util.addIfNotNone(properties, "receiveExit", roleProperties.optString("websphere.sibwmqserversvrconnchannel.receiveexit", None));
  Util.addIfNotNone(properties, "sslType", roleProperties.optString("websphere.sibwmqserversvrconnchannel.ssltype", None));
  Util.addIfNotNone(properties, "securityExitInit", roleProperties.optString("websphere.sibwmqserversvrconnchannel.securityexitinit", None));
  Util.addIfNotNone(properties, "sendExit", roleProperties.optString("websphere.sibwmqserversvrconnchannel.sendexit", None));
  Util.addIfNotNone(properties, "receiveExitInit", roleProperties.optString("websphere.sibwmqserversvrconnchannel.receiveexitinit", None));
  Util.addIfNotNone(properties, "sslEndpoint", roleProperties.optString("websphere.sibwmqserversvrconnchannel.sslendpoint", None));
  Util.addIfNotNone(properties, "sslChain", roleProperties.optString("websphere.sibwmqserversvrconnchannel.sslchain", None));
  Util.addIfNotNone(properties, "securityExit", roleProperties.optString("websphere.sibwmqserversvrconnchannel.securityexit", None));
  Util.addIfNotNone(properties, "sslCRL", roleProperties.optString("websphere.sibwmqserversvrconnchannel.sslcrl", None));
  print "Creating SIBWMQServerSvrconnChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBWMQServerSvrconnChannel", parentid, properties);
  Util.popPathElement('SIBWMQServerSvrconnChannel');

def update(objid,jsonobject):
  Util.pushPathElement('SIBWMQServerSvrconnChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWMQServerSvrconnChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwmqserversvrconnchannel.sendexitinit", None), "sendExitInit","SIBWMQServerSvrconnChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwmqserversvrconnchannel.name", None), "name","SIBWMQServerSvrconnChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwmqserversvrconnchannel.sslreset", None), "sslReset","SIBWMQServerSvrconnChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwmqserversvrconnchannel.sslpeer", None), "sslPeer","SIBWMQServerSvrconnChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwmqserversvrconnchannel.receiveexit", None), "receiveExit","SIBWMQServerSvrconnChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwmqserversvrconnchannel.ssltype", None), "sslType","SIBWMQServerSvrconnChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwmqserversvrconnchannel.securityexitinit", None), "securityExitInit","SIBWMQServerSvrconnChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwmqserversvrconnchannel.sendexit", None), "sendExit","SIBWMQServerSvrconnChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwmqserversvrconnchannel.receiveexitinit", None), "receiveExitInit","SIBWMQServerSvrconnChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwmqserversvrconnchannel.sslendpoint", None), "sslEndpoint","SIBWMQServerSvrconnChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwmqserversvrconnchannel.sslchain", None), "sslChain","SIBWMQServerSvrconnChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwmqserversvrconnchannel.securityexit", None), "securityExit","SIBWMQServerSvrconnChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwmqserversvrconnchannel.sslcrl", None), "sslCRL","SIBWMQServerSvrconnChannel");
  if len(atts) != 0:
    print "Modifying SIBWMQServerSvrconnChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBWMQServerSvrconnChannel configuration up to date.";

  Util.popPathElement('SIBWMQServerSvrconnChannel');
