from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBWSSecurityResponseConsumerBindingConfig')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBWSSecurityResponseConsumerBindingConfig");
  exportedObject.put("roleName", "WebSphereSIBWSSecurityResponseConsumerBindingConfig");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwssecurityresponseconsumerbindingconfig.name", objid, "name","SIBWSSecurityResponseConsumerBindingConfig");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBWSSecurityResponseConsumerBindingConfig');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBWSSecurityResponseConsumerBindingConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSSecurityResponseConsumerBindingConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibwssecurityresponseconsumerbindingconfig.name", None));
  print "Creating SIBWSSecurityResponseConsumerBindingConfig with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBWSSecurityResponseConsumerBindingConfig", parentid, properties);
  Util.popPathElement('SIBWSSecurityResponseConsumerBindingConfig');

def update(objid,jsonobject):
  Util.pushPathElement('SIBWSSecurityResponseConsumerBindingConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSSecurityResponseConsumerBindingConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwssecurityresponseconsumerbindingconfig.name", None), "name","SIBWSSecurityResponseConsumerBindingConfig");
  if len(atts) != 0:
    print "Modifying SIBWSSecurityResponseConsumerBindingConfig with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBWSSecurityResponseConsumerBindingConfig configuration up to date.";

  Util.popPathElement('SIBWSSecurityResponseConsumerBindingConfig');
