from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASQName')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASQName");
  exportedObject.put("roleName", "WebSphereWASQName");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasqname.localpart", objid, "localPart","WASQName");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasqname.combinedqname", objid, "combinedQName","WASQName");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasqname.namespaceuri", objid, "namespaceURI","WASQName");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasqname.internalprefixornsuri", objid, "internalPrefixOrNsURI","WASQName");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASQName');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASQName')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASQName resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "localPart", roleProperties.optString("websphere.wasqname.localpart", None));
  Util.addIfNotNone(properties, "combinedQName", roleProperties.optString("websphere.wasqname.combinedqname", None));
  Util.addIfNotNone(properties, "namespaceURI", roleProperties.optString("websphere.wasqname.namespaceuri", None));
  Util.addIfNotNone(properties, "internalPrefixOrNsURI", roleProperties.optString("websphere.wasqname.internalprefixornsuri", None));
  print "Creating WASQName with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASQName", parentid, properties);
  Util.popPathElement('WASQName');

def update(objid,jsonobject):
  Util.pushPathElement('WASQName')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASQName resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasqname.localpart", None), "localPart","WASQName");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasqname.combinedqname", None), "combinedQName","WASQName");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasqname.namespaceuri", None), "namespaceURI","WASQName");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasqname.internalprefixornsuri", None), "internalPrefixOrNsURI","WASQName");
  if len(atts) != 0:
    print "Modifying WASQName with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASQName configuration up to date.";

  Util.popPathElement('WASQName');
