/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.unix;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.environment.Environment;
import com.urbancode.commons.util.lazy.LazyFinalReference;
import com.urbancode.commons.util.lazy.SafeLazyFinalReference;
import com.urbancode.commons.util.processes.Processes;
import com.urbancode.commons.util.unix.Command;
import com.urbancode.commons.util.unix.UnixCommandUnavailableException;
import com.urbancode.commons.util.unix.UnixPermissions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class Unix {
    private static final Logger log = Logger.getLogger(Unix.class);
    private static final Collection<String> specialChars;
    static final String LS_KEY = "com.urbancode.process.unix.ls";
    static final String UNAME_KEY = "com.urbancode.process.unix.uname";
    static final String LN_KEY = "com.urbancode.process.unix.ln";
    static final String ENV_KEY = "com.urbancode.process.unix.env";
    static final String RM_KEY = "com.urbancode.process.unix.rm";
    static final String TEST_KEY = "com.urbancode.process.unix.test";
    static final String SU_KEY = "com.urbancode.process.unix.su";
    static final String SUDO_KEY = "com.urbancode.process.unix.sudo";
    static final String SH_KEY = "com.urbancode.process.unix.sh";
    static final String CHOWN_KEY = "com.urbancode.process.unix.chown";
    static final String CHMOD_KEY = "com.urbancode.process.unix.chmod";
    static final String CHGRP_KEY = "com.urbancode.process.unix.chgrp";
    static final String SYSTEM_TEMP_KEY = "com.urbancode.process.unix.systemTemp";
    private static final Pattern LS_LINE_PATTERN;
    private static final int MODE = 1;
    private static final int OWNER = 2;
    private static final int GROUP = 3;
    private static final int NAME = 4;
    private static final int LS_GROUP_COUNT = 4;
    private final boolean isUnix = Boolean.valueOf(System.getProperty("com.urbancode.process.unix.isUnix", Boolean.toString(File.pathSeparatorChar == ':' && File.separatorChar == '/')));
    private final Processes processes;
    private final Environment environment;
    private final LazyFinalReference<String> systemTempPath = new SafeLazyFinalReference<String>(){

        @Override
        protected String initialValue() {
            return Unix.this.locateDirectory(System.getProperty(Unix.SYSTEM_TEMP_KEY, "/tmp"));
        }
    };
    private final LazyFinalReference<String> chmodPath = new SafeLazyFinalReference<String>(){

        @Override
        protected String initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("chmodPath is undefined; setting value");
            }
            return Unix.this.locateCommand(System.getProperty(Unix.CHMOD_KEY, "/bin/chmod"));
        }
    };
    private final LazyFinalReference<String> chownPath = new SafeLazyFinalReference<String>(){

        @Override
        protected String initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("chownPath is undefined; setting value");
            }
            return Unix.this.locateCommand(System.getProperty(Unix.CHOWN_KEY, "/bin/chown"));
        }
    };
    private final LazyFinalReference<String> chgrpPath = new SafeLazyFinalReference<String>(){

        @Override
        protected String initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("chgrpPath is undefined; setting value");
            }
            return Unix.this.locateCommand(System.getProperty(Unix.CHGRP_KEY, "/bin/chgrp"));
        }
    };
    private final LazyFinalReference<String> shPath = new SafeLazyFinalReference<String>(){

        @Override
        protected String initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("shPath is undefined; setting value");
            }
            return Unix.this.locateCommand(System.getProperty(Unix.SH_KEY, "/bin/sh"));
        }
    };
    private final LazyFinalReference<String> suPath = new SafeLazyFinalReference<String>(){

        @Override
        protected String initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("suPath is undefined; setting value");
            }
            return Unix.this.locateCommand(System.getProperty(Unix.SU_KEY, "/bin/su"));
        }
    };
    private final LazyFinalReference<String> sudoPath = new SafeLazyFinalReference<String>(){

        @Override
        protected String initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("sudoPath is undefined; setting value");
            }
            return Unix.this.locateCommand(System.getProperty(Unix.SUDO_KEY, "/bin/sudo"));
        }
    };
    private final LazyFinalReference<String> testPath = new SafeLazyFinalReference<String>(){

        @Override
        protected String initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("testPath is undefined; setting value");
            }
            return Unix.this.locateCommand(System.getProperty(Unix.TEST_KEY, "/usr/bin/test"));
        }
    };
    private final LazyFinalReference<String> rmPath = new SafeLazyFinalReference<String>(){

        @Override
        protected String initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("rmPath is undefined; setting value");
            }
            return Unix.this.locateCommand(System.getProperty(Unix.RM_KEY, "/bin/rm"));
        }
    };
    private final LazyFinalReference<String> envPath = new SafeLazyFinalReference<String>(){

        @Override
        protected String initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("envPath is undefined; setting value");
            }
            return Unix.this.locateCommand(System.getProperty(Unix.ENV_KEY, "/usr/bin/env"));
        }
    };
    private final LazyFinalReference<String> lnPath = new SafeLazyFinalReference<String>(){

        @Override
        protected String initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("lnPath is undefined; setting value");
            }
            return Unix.this.locateCommand(System.getProperty(Unix.LN_KEY, "/bin/ln"));
        }
    };
    private final LazyFinalReference<String> lsPath = new SafeLazyFinalReference<String>(){

        @Override
        protected String initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("lsPath is undefined; setting value");
            }
            return Unix.this.locateCommand(System.getProperty(Unix.LS_KEY, "/bin/ls"));
        }
    };
    private final LazyFinalReference<String> unamePath = new SafeLazyFinalReference<String>(){

        @Override
        protected String initialValue() {
            if (log.isDebugEnabled()) {
                log.debug("unamePath is undefined; setting value");
            }
            return Unix.this.locateCommand(System.getProperty(Unix.UNAME_KEY, "/bin/uname"));
        }
    };

    private static boolean requiresDisplayQuotes(String value) {
        if (value == null) {
            return false;
        }
        if ("".equals(value)) {
            return true;
        }
        for (String special : specialChars) {
            if (!value.contains(special)) continue;
            return true;
        }
        return false;
    }

    public static String addDisplayQuotes(String string) {
        return Unix.requiresDisplayQuotes(string) ? Unix.escapeSh(string) : string;
    }

    public static String escapeSh(String string) {
        String result = null;
        if (string != null) {
            result = string.replace("'", "'\\''");
            result = "'" + result + "'";
        }
        return result;
    }

    public Unix() {
        this(new Processes(), Environment.getGlobalInstance());
    }

    @Deprecated
    public Unix(Processes processes) {
        this(processes, Environment.getGlobalInstance());
    }

    public Unix(Processes processes, Environment environment) {
        this.processes = Check.nonNull(processes, "processes");
        this.environment = Check.nonNull(environment, "environment");
    }

    public boolean isUnix() {
        return this.isUnix;
    }

    public String systemTempPath() {
        return this.systemTempPath.get();
    }

    public String chmodPath() throws UnixCommandUnavailableException {
        String result = this.chmodPath.get();
        if (result == null) {
            throw new UnixCommandUnavailableException("'chmod' is unavailable");
        }
        return result;
    }

    public String chownPath() throws UnixCommandUnavailableException {
        String result = this.chownPath.get();
        if (result == null) {
            throw new UnixCommandUnavailableException("'chown' is unavailable");
        }
        return result;
    }

    public String chgrpPath() throws UnixCommandUnavailableException {
        String result = this.chgrpPath.get();
        if (result == null) {
            throw new UnixCommandUnavailableException("'chgrp' is unavailable");
        }
        return result;
    }

    public String shPath() throws UnixCommandUnavailableException {
        String result = this.shPath.get();
        if (result == null) {
            throw new UnixCommandUnavailableException("'sh' is unavailable");
        }
        return result;
    }

    public String suPath() throws UnixCommandUnavailableException {
        String result = this.suPath.get();
        if (result == null) {
            throw new UnixCommandUnavailableException("'su' is unavailable");
        }
        return result;
    }

    public String sudoPath() throws UnixCommandUnavailableException {
        String result = this.sudoPath.get();
        if (result == null) {
            throw new UnixCommandUnavailableException("'sudo' is unavailable");
        }
        return result;
    }

    public String testPath() throws UnixCommandUnavailableException {
        String result = this.testPath.get();
        if (result == null) {
            throw new UnixCommandUnavailableException("'test' is unavailable");
        }
        return result;
    }

    public String rmPath() throws UnixCommandUnavailableException {
        String result = this.rmPath.get();
        if (result == null) {
            throw new UnixCommandUnavailableException("'rm' is unavailable");
        }
        return result;
    }

    public String envPath() throws UnixCommandUnavailableException {
        String result = this.envPath.get();
        if (result == null) {
            throw new UnixCommandUnavailableException("'env' is unavailable");
        }
        return result;
    }

    public String lnPath() throws UnixCommandUnavailableException {
        String result = this.lnPath.get();
        if (result == null) {
            throw new UnixCommandUnavailableException("'ln' is unavailable");
        }
        return result;
    }

    public String lsPath() throws UnixCommandUnavailableException {
        String result = this.lsPath.get();
        if (result == null) {
            throw new UnixCommandUnavailableException("'ls' is unavailable");
        }
        return result;
    }

    public String unamePath() throws UnixCommandUnavailableException {
        String result = this.unamePath.get();
        if (result == null) {
            throw new UnixCommandUnavailableException("'uname' is unavailable");
        }
        return result;
    }

    public UnixPermissions getPermissions(File path) throws IOException {
        return this.ls(path, new LsLineHandler<UnixPermissions>(){

            @Override
            public UnixPermissions handle(Matcher matcher) throws IOException {
                String mode = matcher.group(1);
                String owner = matcher.group(2);
                String group = matcher.group(3);
                return UnixPermissions.createFromText(mode, owner, group);
            }
        });
    }

    public String readlink(File path) throws IOException {
        return this.ls(path, new LsLineHandler<String>(){

            @Override
            public String handle(Matcher matcher) {
                String result = null;
                String mode = matcher.group(1);
                String name = matcher.group(4);
                if (mode.charAt(0) == 'l') {
                    result = name.split(Pattern.quote(" -> "))[1].trim();
                }
                return result;
            }
        });
    }

    public void ln(final LinkType type, final String target, final String linkName) throws IOException {
        Check.nonNull(type, "type");
        Check.nonNull(target, "target");
        Check.nonNull(linkName, "linkName");
        Command<Void> command = new Command<Void>(Command.OutputMode.DISCARD, this.processes, this.environment){

            @Override
            protected void buildCommand(List<String> command) throws IOException {
                command.add(Unix.this.lnPath());
                if (type == LinkType.SYMBOLIC) {
                    command.add("-s");
                }
                command.add(target);
                command.add(linkName);
            }
        };
        command.execute();
    }

    public void mksymlink(File link, String target) throws IOException {
        Check.nonNull(target, "target");
        Check.nonNull(link, "linkPath");
        this.ln(LinkType.SYMBOLIC, target, link.getAbsolutePath());
    }

    public void mkhardlink(File link, File target) throws IOException {
        Check.nonNull(target, "target");
        Check.nonNull(link, "linkPath");
        this.ln(LinkType.HARD, target.getAbsolutePath(), link.getAbsolutePath());
    }

    public void chown(File file, String user, String group) throws IOException {
        this.chown(file, user, group, false);
    }

    public void chown(File file, String user) throws IOException {
        this.chown(file, user, null, false);
    }

    public void chown(File file, final String user, final String group, final boolean recursive) throws IOException {
        Check.nonNull(file, "file");
        Check.nonNull(user, "user");
        final String path = file.getAbsolutePath();
        if (!file.exists()) {
            throw new FileNotFoundException(path);
        }
        Command<Void> command = new Command<Void>(Command.OutputMode.DISCARD, this.processes, this.environment){

            @Override
            protected void buildCommand(List<String> command) throws IOException {
                command.add(Unix.this.chownPath());
                if (recursive) {
                    command.add("-R");
                }
                command.add(user + (group == null ? "" : ":" + group));
                command.add(path);
            }
        };
        command.execute();
    }

    public void chmod(File file, int mode) throws IOException {
        this.chmod(file, mode, false);
    }

    public void chmod(File file, String symbolicMode) throws IOException {
        this.chmod(file, symbolicMode, false);
    }

    public void chmod(File file, final int mode, final boolean recursive) throws IOException {
        Check.nonNull(file, "file");
        if (mode < 0 || mode > 7777) {
            throw new IllegalArgumentException("invalid mode");
        }
        final String path = file.getAbsolutePath();
        if (!file.exists()) {
            throw new FileNotFoundException(path);
        }
        Command<Void> command = new Command<Void>(Command.OutputMode.DISCARD, this.processes, this.environment){

            @Override
            protected void buildCommand(List<String> command) throws IOException {
                command.add(Unix.this.chmodPath());
                if (recursive) {
                    command.add("-R");
                }
                command.add(UnixPermissions.toOctal(mode));
                command.add(path);
            }
        };
        command.execute();
    }

    public void chmod(File file, final String symbolicMode, final boolean recursive) throws IOException {
        Check.nonNull(file, "file");
        final String path = file.getAbsolutePath();
        if (!file.exists()) {
            throw new FileNotFoundException(path);
        }
        Command<Void> command = new Command<Void>(Command.OutputMode.DISCARD, this.processes, this.environment){

            @Override
            protected void buildCommand(List<String> command) throws IOException {
                command.add(Unix.this.chmodPath());
                if (recursive) {
                    command.add("-R");
                }
                command.add(symbolicMode);
                command.add(path);
            }
        };
        command.execute();
    }

    public void chgrp(File file, String group) throws IOException {
        this.chgrp(file, group, false);
    }

    public void chgrp(File file, final String group, final boolean recursive) throws IOException {
        Check.nonNull(file, "file");
        Check.nonNull(group, "group");
        final String path = file.getAbsolutePath();
        if (!file.exists()) {
            throw new FileNotFoundException(path);
        }
        Command<Void> command = new Command<Void>(Command.OutputMode.DISCARD, this.processes, this.environment){

            @Override
            protected void buildCommand(List<String> command) throws IOException {
                command.add(Unix.this.chgrpPath());
                if (recursive) {
                    command.add("-R");
                }
                command.add(group);
                command.add(path);
            }
        };
        command.execute();
    }

    public String uname(final UnameOption option) throws IOException {
        Command<String> command = new Command<String>(Command.OutputMode.STRING, this.processes, this.environment){

            @Override
            protected void buildCommand(List<String> command) throws IOException {
                command.add(Unix.this.unamePath());
                if (option != null) {
                    command.add(option.option());
                }
            }

            @Override
            protected String processOutput(String output) {
                return output;
            }
        };
        return ((String)command.execute()).trim();
    }

    public boolean isRoot() {
        return "root".equals(System.getProperty("user.name"));
    }

    private <T> T ls(File path, final LsLineHandler<T> handler) throws IOException {
        Check.nonNull(path, "path");
        Check.nonNull(handler, "handler");
        final String absolutePath = path.getAbsolutePath();
        Command command = new Command<T>(Command.OutputMode.STRING, this.processes, this.environment){

            @Override
            protected void buildCommand(List<String> command) throws IOException {
                command.add(Unix.this.lsPath());
                command.add("-l");
                command.add("-d");
                command.add(absolutePath);
            }

            @Override
            protected T processOutput(String output) throws IOException {
                Object result = null;
                Matcher matcher = LS_LINE_PATTERN.matcher(output);
                if (!matcher.matches() || matcher.groupCount() != 4) {
                    throw new IOException("Unable to parse ls output for " + absolutePath + ": " + StringUtil.escapeJava(output));
                }
                result = handler.handle(matcher);
                return result;
            }
        };
        return command.execute();
    }

    private String locateCommand(String command) {
        Check.nonNull(command, "command");
        String result = null;
        File commandFile = new File(command);
        String commandName = commandFile.getName();
        if (commandFile.isFile()) {
            if (log.isDebugEnabled()) {
                log.debug("Command '" + commandName + "' located at default path " + commandFile);
            }
            result = command;
        } else {
            String pathValue;
            if (log.isDebugEnabled()) {
                log.debug("Scanning PATH for '" + commandName + "'");
            }
            if ((pathValue = this.environment.get("PATH")) != null) {
                for (String element : pathValue.split(Pattern.quote(File.pathSeparator))) {
                    String path;
                    if (element == null || element.length() <= 0 || !new File(path = element + File.separator + commandName).isFile()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Command '" + commandName + "' located at path " + path);
                    }
                    result = path;
                    break;
                }
            }
        }
        if (log.isDebugEnabled() && result == null) {
            log.debug("Command '" + commandName + "' not found");
        }
        return result;
    }

    private String locateDirectory(String directory) {
        Check.nonNull(directory, "directory");
        String result = null;
        File directoryFile = new File(directory);
        if (directoryFile.isDirectory()) {
            result = directory;
        }
        if (log.isDebugEnabled()) {
            if (result != null) {
                log.debug("Directory '" + directory + "' found");
            } else {
                log.debug("Directory '" + directory + "' not found");
            }
        }
        return result;
    }

    static {
        LinkedHashSet chars = new LinkedHashSet();
        Collections.addAll(chars, "|&;()<> \t\n".split(""));
        Collections.addAll(chars, "{}".split(""));
        Collections.addAll(chars, "'\"\\".split(""));
        Collections.addAll(chars, "$[]*!".split(""));
        Collections.addAll(chars, "`".split(""));
        chars.remove("");
        specialChars = Collections.unmodifiableCollection(chars);
        String WS = "\\s+";
        String MODE = "^(\\S+)";
        String LINKS = "\\d+";
        String OWNER = "(\\S+)";
        String GROUP = "(\\S+)";
        String SIZE = "\\d+";
        String DATE = "\\S+\\s+\\S+\\s+\\S+";
        String PATH = "(.+)";
        LS_LINE_PATTERN = Pattern.compile(MODE + WS + LINKS + WS + OWNER + WS + GROUP + WS + SIZE + WS + DATE + WS + PATH, 32);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    static interface LsLineHandler<T> {
        public T handle(Matcher var1) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    public static enum UnameOption {
        ALL{

            String option() {
                return "-a";
            }
        }
        ,
        MACHINE{

            String option() {
                return "-m";
            }
        }
        ,
        NODE{

            String option() {
                return "-n";
            }
        }
        ,
        RELEASE{

            String option() {
                return "-r";
            }
        }
        ,
        SYSTEM{

            String option() {
                return "-s";
            }
        }
        ,
        VERSION{

            String option() {
                return "-v";
            }
        };


        abstract String option();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    public static enum LinkType {
        SYMBOLIC,
        HARD;

    }
}

