from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.objectpoolmanagerinfo.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'ObjectPoolManagerInfo');

  containmentpath = "%(parentconpath)sObjectPoolManagerInfo:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('ObjectPoolManagerInfo')

  name = Util.getRequiredAttribute(objid, "name", 'ObjectPoolManagerInfo');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereObjectPoolManagerInfo");
  exportedObject.put("roleName", "WebSphereObjectPoolManagerInfo");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectpoolmanagerinfo.name", objid, "name","ObjectPoolManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectpoolmanagerinfo.category", objid, "category","ObjectPoolManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectpoolmanagerinfo.providertype", objid, "providerType","ObjectPoolManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectpoolmanagerinfo.jndiname", objid, "jndiName","ObjectPoolManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectpoolmanagerinfo.description", objid, "description","ObjectPoolManagerInfo");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ObjectPoolManagerInfo');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("ObjectPoolManagerInfo resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.objectpoolmanagerinfo.name"):
    raise Exception("Resource role properties does not contain websphere.objectpoolmanagerinfo.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create ObjectPoolManagerInfo on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('ObjectPoolManagerInfo')
  if not jsonobject.has("roleProperties"):
    raise Exception("ObjectPoolManagerInfo resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.objectpoolmanagerinfo.name"):
    raise Exception("Resource role properties does not contain websphere.objectpoolmanagerinfo.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.objectpoolmanagerinfo.name", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.objectpoolmanagerinfo.category", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.objectpoolmanagerinfo.providertype", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.objectpoolmanagerinfo.jndiname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.objectpoolmanagerinfo.description", None));
  print "Creating ObjectPoolManagerInfo with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ObjectPoolManagerInfo", parentid, properties);
  Util.popPathElement('ObjectPoolManagerInfo');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('ObjectPoolManagerInfo')
  if not jsonobject.has("roleProperties"):
    raise Exception("ObjectPoolManagerInfo resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.objectpoolmanagerinfo.name"):
    raise Exception("Resource role properties does not contain websphere.objectpoolmanagerinfo.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectpoolmanagerinfo.name", None), "name","ObjectPoolManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectpoolmanagerinfo.category", None), "category","ObjectPoolManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectpoolmanagerinfo.providertype", None), "providerType","ObjectPoolManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectpoolmanagerinfo.jndiname", None), "jndiName","ObjectPoolManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectpoolmanagerinfo.description", None), "description","ObjectPoolManagerInfo");
  if len(atts) != 0:
    print "Modifying ObjectPoolManagerInfo with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ObjectPoolManagerInfo configuration up to date.";

  Util.popPathElement('ObjectPoolManagerInfo');
