from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBWSSecurityResponseSenderBindingConfig')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBWSSecurityResponseSenderBindingConfig");
  exportedObject.put("roleName", "WebSphereSIBWSSecurityResponseSenderBindingConfig");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwssecurityresponsesenderbindingconfig.name", objid, "name","SIBWSSecurityResponseSenderBindingConfig");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBWSSecurityResponseSenderBindingConfig');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBWSSecurityResponseSenderBindingConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSSecurityResponseSenderBindingConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibwssecurityresponsesenderbindingconfig.name", None));
  print "Creating SIBWSSecurityResponseSenderBindingConfig with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBWSSecurityResponseSenderBindingConfig", parentid, properties);
  Util.popPathElement('SIBWSSecurityResponseSenderBindingConfig');

def update(objid,jsonobject):
  Util.pushPathElement('SIBWSSecurityResponseSenderBindingConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSSecurityResponseSenderBindingConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwssecurityresponsesenderbindingconfig.name", None), "name","SIBWSSecurityResponseSenderBindingConfig");
  if len(atts) != 0:
    print "Modifying SIBWSSecurityResponseSenderBindingConfig with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBWSSecurityResponseSenderBindingConfig configuration up to date.";

  Util.popPathElement('SIBWSSecurityResponseSenderBindingConfig');
