from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WSNTopicNamespace')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWSNTopicNamespace");
  exportedObject.put("roleName", "WebSphereWSNTopicNamespace");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsntopicnamespace.messagereliability", objid, "messageReliability","WSNTopicNamespace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsntopicnamespace.sibtopicspacename", objid, "sibTopicSpaceName","WSNTopicNamespace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsntopicnamespace.createdsibtopicspace", objid, "createdSIBTopicSpace","WSNTopicNamespace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsntopicnamespace.uuid", objid, "uuid","WSNTopicNamespace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsntopicnamespace.namespace", objid, "namespace","WSNTopicNamespace");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'property',"WSNTopicNamespace");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WSNTopicNamespace');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WSNTopicNamespace')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSNTopicNamespace resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "messageReliability", roleProperties.optString("websphere.wsntopicnamespace.messagereliability", None));
  Util.addIfNotNone(properties, "sibTopicSpaceName", roleProperties.optString("websphere.wsntopicnamespace.sibtopicspacename", None));
  Util.addIfNotNone(properties, "createdSIBTopicSpace", roleProperties.optString("websphere.wsntopicnamespace.createdsibtopicspace", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.wsntopicnamespace.uuid", None));
  Util.addIfNotNone(properties, "namespace", roleProperties.optString("websphere.wsntopicnamespace.namespace", None));
  print "Creating WSNTopicNamespace with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WSNTopicNamespace", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WSNTopicNamespace');

def update(objid,jsonobject):
  Util.pushPathElement('WSNTopicNamespace')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSNTopicNamespace resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsntopicnamespace.messagereliability", None), "messageReliability","WSNTopicNamespace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsntopicnamespace.sibtopicspacename", None), "sibTopicSpaceName","WSNTopicNamespace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsntopicnamespace.createdsibtopicspace", None), "createdSIBTopicSpace","WSNTopicNamespace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsntopicnamespace.uuid", None), "uuid","WSNTopicNamespace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsntopicnamespace.namespace", None), "namespace","WSNTopicNamespace");
  if len(atts) != 0:
    print "Modifying WSNTopicNamespace with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WSNTopicNamespace configuration up to date.";

  Property.removeProperties(objid, 'property',"WSNTopicNamespace");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WSNTopicNamespace');
