###
# Licensed Materials - Property of IBM* and/or HCL**
# (c) Copyright IBM Corporation 2015, 2017. All Rights Reserved.
# (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
#
# U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
# GSA ADP Schedule Contract with IBM Corp.
#
# * Trademark of International Business Machines
# ** Trademark of HCL Technologies Limited

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = None;


def _export(parentrespath, repo, entityType):
  Util.pushPathElement('LDAPEntityType')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':entityType }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", entityType);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereLDAPEntityType");
  exportedObject.put("roleName", "WebSphereLDAPEntityType");

  roleProperties = JSONObject();

  # Get the config
  params = '[-id "' + repo + '" -name ' + entityType +']';
  config = Util.getIdMgrLDAPEntityType(params);
  Util.addToJsonIfNotNone(roleProperties, "name", entityType);
  Util.addToJsonIfNotNone(roleProperties, "searchFilter", Util.getStringParam(config, "searchFilter"));
  Util.addToJsonIfNotNone(roleProperties, "objectClasses", Util.getListParam(config, "objectClasses"));
  Util.addToJsonIfNotNone(roleProperties, "objectClassesForCreate", Util.getListParam(config, "objectClassesForCreate"));
  Util.addToJsonIfNotNone(roleProperties, "searchBases", Util.getListParam(config, "searchBases"));

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('LDAPEntityType');
  return result;

def create(roleProperties, repo):
  Util.pushPathElement('LDAPEntityType')
  name = roleProperties.optString("name", None);
  addIdMgrLDAPEntityTypeParams = '[-id "' + repo + '" -name ' + name;
  addIdMgrLDAPEntityTypeParams = Util.addParmIfNotNone(roleProperties, "searchFilter", addIdMgrLDAPEntityTypeParams);
  addIdMgrLDAPEntityTypeParams = Util.addParmIfNotNone(roleProperties, "objectClasses", addIdMgrLDAPEntityTypeParams);
  addIdMgrLDAPEntityTypeParams = Util.addParmIfNotNone(roleProperties, "objectClassesForCreate", addIdMgrLDAPEntityTypeParams);
  addIdMgrLDAPEntityTypeParams = Util.addParmIfNotNone(roleProperties, "searchBases", addIdMgrLDAPEntityTypeParams);
  addIdMgrLDAPEntityTypeParams = addIdMgrLDAPEntityTypeParams + "]";
  Log.debug("Running command to create LDAP entity type: AdminTask.addIdMgrLDAPEntityType(" + addIdMgrLDAPEntityTypeParams + ")");
  Util.addIdMgrLDAPEntityType(addIdMgrLDAPEntityTypeParams);
  Util.popPathElement('LDAPEntityType');

def update(jsonobject, repo):
  Util.pushPathElement('LDAPEntityType')
  if not jsonobject.has("roleProperties"):
    raise Exception("LDAPEntityType resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  name = roleProperties.optString("name", None);
  # Check if the LDAPEntity already exists.
  # Get list of LDAPEntityTypes
  params = '[-id "' + repo + '"]';
  entityTypes = Util.listIdMgrLDAPEntityTypes(params);
  entityTypeList = entityTypes.split("\n");
  # If the LDAPEntity doesn't already exist, create it.  Else, update it.
  if name not in entityTypeList:
    create(roleProperties, repo);
  else:
    updateIdMgrLDAPEntityTypeParams = '[-id "' + repo + '" -name ' + name;
    updateIdMgrLDAPEntityTypeParams = Util.addParmIfNotNone(roleProperties, "searchFilter", updateIdMgrLDAPEntityTypeParams);
    updateIdMgrLDAPEntityTypeParams = Util.addParmIfNotNone(roleProperties, "objectClasses", updateIdMgrLDAPEntityTypeParams);
    updateIdMgrLDAPEntityTypeParams = Util.addParmIfNotNone(roleProperties, "objectClassesForCreate", updateIdMgrLDAPEntityTypeParams);
    updateIdMgrLDAPEntityTypeParams = Util.addParmIfNotNone(roleProperties, "searchBases", updateIdMgrLDAPEntityTypeParams);
    updateIdMgrLDAPEntityTypeParams = updateIdMgrLDAPEntityTypeParams + "]";
    Log.debug("Running command to update LDAP entity type: AdminTask.updateIdMgrLDAPEntityType(" + updateIdMgrLDAPEntityTypeParams + ")");
    Util.updateIdMgrLDAPEntityType(updateIdMgrLDAPEntityTypeParams);
  Util.popPathElement('LDAPEntityType');

def remove(id, name):
  deleteIdMgrLDAPEntityTypeParams = '[-id "' + id + '" -name ' + name + ']';
  Log.debug("Running command to remove LDAP entity type: AdminTask.deleteIdMgrLDAPEntityType(" + deleteIdMgrLDAPEntityTypeParams + ")");
  Util.deleteIdMgrLDAPEntityType(deleteIdMgrLDAPEntityTypeParams);

