from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ProcessExecution')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereProcessExecution");
  exportedObject.put("roleName", "WebSphereProcessExecution");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.processexecution.runasuser", objid, "runAsUser","ProcessExecution");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.processexecution.runasgroup", objid, "runAsGroup","ProcessExecution");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.processexecution.runinprocessgroup", objid, "runInProcessGroup","ProcessExecution");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.processexecution.umask", objid, "umask","ProcessExecution");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.processexecution.processpriority", objid, "processPriority","ProcessExecution");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ProcessExecution');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ProcessExecution')
  if not jsonobject.has("roleProperties"):
    raise Exception("ProcessExecution resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "runAsUser", roleProperties.optString("websphere.processexecution.runasuser", None));
  Util.addIfNotNone(properties, "runAsGroup", roleProperties.optString("websphere.processexecution.runasgroup", None));
  Util.addIfNotNone(properties, "runInProcessGroup", roleProperties.optString("websphere.processexecution.runinprocessgroup", None));
  Util.addIfNotNone(properties, "umask", roleProperties.optString("websphere.processexecution.umask", None));
  Util.addIfNotNone(properties, "processPriority", roleProperties.optString("websphere.processexecution.processpriority", None));
  print "Creating ProcessExecution with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ProcessExecution", parentid, properties);
  Util.popPathElement('ProcessExecution');

def update(objid,jsonobject):
  Util.pushPathElement('ProcessExecution')
  if not jsonobject.has("roleProperties"):
    raise Exception("ProcessExecution resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.processexecution.runasuser", None), "runAsUser","ProcessExecution");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.processexecution.runasgroup", None), "runAsGroup","ProcessExecution");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.processexecution.runinprocessgroup", None), "runInProcessGroup","ProcessExecution");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.processexecution.umask", None), "umask","ProcessExecution");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.processexecution.processpriority", None), "processPriority","ProcessExecution");
  if len(atts) != 0:
    print "Modifying ProcessExecution with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ProcessExecution configuration up to date.";

  Util.popPathElement('ProcessExecution');
