from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBTopicSpaceAudit import SIBTopicSpaceAudit;

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAudit')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAudit");
  exportedObject.put("roleName", "WebSphereSIBAudit");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibaudit.allowaudit", objid, "allowAudit","SIBAudit");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  topicSpaceAudits = Util.parseConfigIdListAttribute(objid, 'topicSpaceAudit', 'SIBAudit');
  for topicSpaceAudit in topicSpaceAudits:
    if len(topicSpaceAudit) > 0:
      returndict = Util.createTypeFolder(respath, "SIBTopicSpaceAudit", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SIBTopicSpaceAudit._export(topicSpaceAudit, currespath, "SIBTopicSpaceAudit%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAudit');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAudit')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAudit resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "allowAudit", roleProperties.optString("websphere.sibaudit.allowaudit", None));
  print "Creating SIBAudit with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAudit", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBTopicSpaceAudit":
        SIBTopicSpaceAudit.create(objid, curjsonobject);

  Util.popPathElement('SIBAudit');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAudit')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAudit resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibaudit.allowaudit", None), "allowAudit","SIBAudit");
  if len(atts) != 0:
    print "Modifying SIBAudit with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAudit configuration up to date.";

  topicSpaceAudits = Util.parseConfigIdListAttribute(objid, 'topicSpaceAudit', 'SIBAudit');
  for topicSpaceAudit in topicSpaceAudits:
    if len(topicSpaceAudit) > 0:
      Util.remove(topicSpaceAudit);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBTopicSpaceAudit":
        SIBTopicSpaceAudit.create(objid, curjsonobject);

  Util.popPathElement('SIBAudit');
