from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property
from StaticCacheRule import StaticCacheRule

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('StaticCachePolicy')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereStaticCachePolicy");
  exportedObject.put("roleName", "WebSphereStaticCachePolicy");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"StaticCachePolicy");

  i = 0;
  staticCacheRules = Util.parseConfigIdListAttribute(objid, 'staticCacheRules',"StaticCachePolicy");
  for staticCacheRule in staticCacheRules:
    if len(staticCacheRule) > 0:
      returndict = Util.createTypeFolder(respath, "StaticCacheRule", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, StaticCacheRule._export(staticCacheRule, currespath, "Static Cache Rule%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('StaticCachePolicy');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('StaticCachePolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("StaticCachePolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating StaticCachePolicy with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("StaticCachePolicy", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereStaticCacheRule":
        StaticCacheRule.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('StaticCachePolicy');

def update(objid,jsonobject):
  Util.pushPathElement('StaticCachePolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("StaticCachePolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying StaticCachePolicy with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "StaticCachePolicy configuration up to date.";

  Property.removeProperties(objid, 'properties',"StaticCachePolicy");

  staticCacheRules = Util.parseConfigIdListAttribute(objid, 'staticCacheRules', "StaticCachePolicy");
  for staticCacheRule in staticCacheRules:
    if len(staticCacheRule) > 0:
      Util.remove(staticCacheRule);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereStaticCacheRule":
        StaticCacheRule.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('StaticCachePolicy');
