from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from EndPoint import EndPoint

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('BackupCluster')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereBackupCluster");
  exportedObject.put("roleName", "WebSphereBackupCluster");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.backupcluster.backupclustername", objid, "backupClusterName","BackupCluster");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  domainBootstrapAddress = Util.getOptionalAttribute(objid, 'domainBootstrapAddress', "BackupCluster");
  if (domainBootstrapAddress != None):
    returndict = Util.createTypeFolder(respath, "EndPoint", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, EndPoint._export(domainBootstrapAddress, currespath, "domainBootstrapAddress"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('BackupCluster');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('BackupCluster')
  if not jsonobject.has("roleProperties"):
    raise Exception("BackupCluster resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "backupClusterName", roleProperties.optString("websphere.backupcluster.backupclustername", None));
  print "Creating BackupCluster with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("BackupCluster", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereEndPoint":
        EndPoint.create(objid, curjsonobject, 'domainBootstrapAddress');

  Util.popPathElement('BackupCluster');

def update(objid,jsonobject):
  Util.pushPathElement('BackupCluster')
  if not jsonobject.has("roleProperties"):
    raise Exception("BackupCluster resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.backupcluster.backupclustername", None), "backupClusterName","BackupCluster");
  if len(atts) != 0:
    print "Modifying BackupCluster with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "BackupCluster configuration up to date.";

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereEndPoint":
        EndPoint.update(objid, curjsonobject);

  Util.popPathElement('BackupCluster');

def getBackupClusters(objid):
  backupClusters = Util.getAssociatedObjects(objid, "BackupCluster", 1);
  return backupClusters;
