from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CompletionTimeGoal')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCompletionTimeGoal");
  exportedObject.put("roleName", "WebSphereCompletionTimeGoal");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.completiontimegoal.importance", objid, "importance","CompletionTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.completiontimegoal.goalvalue", objid, "goalValue","CompletionTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.completiontimegoal.timeperiodvalueunits", objid, "timePeriodValueUnits","CompletionTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.completiontimegoal.violationenabled", objid, "violationEnabled","CompletionTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.completiontimegoal.goaldeltavalueunits", objid, "goalDeltaValueUnits","CompletionTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.completiontimegoal.goalvalueunits", objid, "goalValueUnits","CompletionTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.completiontimegoal.goaldeltavalue", objid, "goalDeltaValue","CompletionTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.completiontimegoal.timeperiodvalue", objid, "timePeriodValue","CompletionTimeGoal");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CompletionTimeGoal');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('CompletionTimeGoal')
  if not jsonobject.has("roleProperties"):
    raise Exception("CompletionTimeGoal resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "importance", roleProperties.optString("websphere.completiontimegoal.importance", None));
  Util.addIfNotNone(properties, "goalValue", roleProperties.optString("websphere.completiontimegoal.goalvalue", None));
  Util.addIfNotNone(properties, "timePeriodValueUnits", roleProperties.optString("websphere.completiontimegoal.timeperiodvalueunits", None));
  Util.addIfNotNone(properties, "violationEnabled", roleProperties.optString("websphere.completiontimegoal.violationenabled", None));
  Util.addIfNotNone(properties, "goalDeltaValueUnits", roleProperties.optString("websphere.completiontimegoal.goaldeltavalueunits", None));
  Util.addIfNotNone(properties, "goalValueUnits", roleProperties.optString("websphere.completiontimegoal.goalvalueunits", None));
  Util.addIfNotNone(properties, "goalDeltaValue", roleProperties.optString("websphere.completiontimegoal.goaldeltavalue", None));
  Util.addIfNotNone(properties, "timePeriodValue", roleProperties.optString("websphere.completiontimegoal.timeperiodvalue", None));
  print "Creating CompletionTimeGoal with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CompletionTimeGoal", parentid, properties);
  Util.popPathElement('CompletionTimeGoal');

def update(objid,jsonobject):
  Util.pushPathElement('CompletionTimeGoal')
  if not jsonobject.has("roleProperties"):
    raise Exception("CompletionTimeGoal resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.completiontimegoal.importance", None), "importance","CompletionTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.completiontimegoal.goalvalue", None), "goalValue","CompletionTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.completiontimegoal.timeperiodvalueunits", None), "timePeriodValueUnits","CompletionTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.completiontimegoal.violationenabled", None), "violationEnabled","CompletionTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.completiontimegoal.goaldeltavalueunits", None), "goalDeltaValueUnits","CompletionTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.completiontimegoal.goalvalueunits", None), "goalValueUnits","CompletionTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.completiontimegoal.goaldeltavalue", None), "goalDeltaValue","CompletionTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.completiontimegoal.timeperiodvalue", None), "timePeriodValue","CompletionTimeGoal");
  if len(atts) != 0:
    print "Modifying CompletionTimeGoal with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CompletionTimeGoal configuration up to date.";

  Util.popPathElement('CompletionTimeGoal');
