from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('JAXWSHandlerList')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJAXWSHandlerList");
  exportedObject.put("roleName", "WebSphereJAXWSHandlerList");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaxwshandlerlist.name", objid, "name","JAXWSHandlerList");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.jaxwshandlerlist.handlername", objid, "handlerName","JAXWSHandlerList");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaxwshandlerlist.description", objid, "description","JAXWSHandlerList");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JAXWSHandlerList');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('JAXWSHandlerList')
  if not jsonobject.has("roleProperties"):
    raise Exception("JAXWSHandlerList resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.jaxwshandlerlist.name", None));
  Util.addPathProperty(properties, "handlerName", roleProperties.optString("websphere.jaxwshandlerlist.handlername", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.jaxwshandlerlist.description", None));
  print "Creating JAXWSHandlerList with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JAXWSHandlerList", parentid, properties);
  Util.popPathElement('JAXWSHandlerList');

def update(objid,jsonobject):
  Util.pushPathElement('JAXWSHandlerList')
  if not jsonobject.has("roleProperties"):
    raise Exception("JAXWSHandlerList resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaxwshandlerlist.name", None), "name","JAXWSHandlerList");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.jaxwshandlerlist.handlername", None), "handlerName","JAXWSHandlerList");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaxwshandlerlist.description", None), "description","JAXWSHandlerList");
  if len(atts) != 0:
    print "Modifying JAXWSHandlerList with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JAXWSHandlerList configuration up to date.";

  Util.popPathElement('JAXWSHandlerList');
