from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WSGWProxyService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWSGWProxyService");
  exportedObject.put("roleName", "WebSphereWSGWProxyService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwproxyservice.outboundservicename", objid, "outboundServiceName","WSGWProxyService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwproxyservice.name", objid, "name","WSGWProxyService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwproxyservice.replydestinationname", objid, "replyDestinationName","WSGWProxyService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwproxyservice.description", objid, "description","WSGWProxyService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwproxyservice.requestdestinationname", objid, "requestDestinationName","WSGWProxyService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwproxyservice.inboundservicename", objid, "inboundServiceName","WSGWProxyService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WSGWProxyService');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WSGWProxyService')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSGWProxyService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "outboundServiceName", roleProperties.optString("websphere.wsgwproxyservice.outboundservicename", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.wsgwproxyservice.name", None));
  Util.addIfNotNone(properties, "replyDestinationName", roleProperties.optString("websphere.wsgwproxyservice.replydestinationname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.wsgwproxyservice.description", None));
  Util.addIfNotNone(properties, "requestDestinationName", roleProperties.optString("websphere.wsgwproxyservice.requestdestinationname", None));
  Util.addIfNotNone(properties, "inboundServiceName", roleProperties.optString("websphere.wsgwproxyservice.inboundservicename", None));
  print "Creating WSGWProxyService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WSGWProxyService", parentid, properties);
  Util.popPathElement('WSGWProxyService');

def update(objid,jsonobject):
  Util.pushPathElement('WSGWProxyService')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSGWProxyService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwproxyservice.outboundservicename", None), "outboundServiceName","WSGWProxyService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwproxyservice.name", None), "name","WSGWProxyService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwproxyservice.replydestinationname", None), "replyDestinationName","WSGWProxyService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwproxyservice.description", None), "description","WSGWProxyService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwproxyservice.requestdestinationname", None), "requestDestinationName","WSGWProxyService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwproxyservice.inboundservicename", None), "inboundServiceName","WSGWProxyService");
  if len(atts) != 0:
    print "Modifying WSGWProxyService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WSGWProxyService configuration up to date.";

  Util.popPathElement('WSGWProxyService');
