from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SSLConfig import SSLConfig

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('com.ibm.etools.webservice.wscext.PortQnameBinding')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherecom.ibm.etools.webservice.wscext.PortQnameBinding");
  exportedObject.put("roleName", "WebSpherecom.ibm.etools.webservice.wscext.PortQnameBinding");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscext.portqnamebinding.portqnamelocalnamelink", objid, "portQnameLocalNameLink","com.ibm.etools.webservice.wscext.PortQnameBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscext.portqnamebinding.portqnamenamespacelink", objid, "portQnameNamespaceLink","com.ibm.etools.webservice.wscext.PortQnameBinding");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  sslConfig = Util.getOptionalAttribute(objid, 'sslConfig', "com.ibm.etools.webservice.wscext.PortQnameBinding");
  if sslConfig is not None and len(sslConfig) > 0:
    returndict = Util.createTypeFolder(respath, "SSLConfig", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SSLConfig._export(sslConfig, currespath, "SSLConfig"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('com.ibm.etools.webservice.wscext.PortQnameBinding');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscext.PortQnameBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscext.PortQnameBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "portQnameLocalNameLink", roleProperties.optString("websphere.com.ibm.etools.webservice.wscext.portqnamebinding.portqnamelocalnamelink", None));
  Util.addIfNotNone(properties, "portQnameNamespaceLink", roleProperties.optString("websphere.com.ibm.etools.webservice.wscext.portqnamebinding.portqnamenamespacelink", None));
  print "Creating com.ibm.etools.webservice.wscext.PortQnameBinding with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("com.ibm.etools.webservice.wscext.PortQnameBinding", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSSLConfig":
        SSLConfig.create(objid, curjsonobject, "sslConfig");
  Util.popPathElement('com.ibm.etools.webservice.wscext.PortQnameBinding');

def update(objid,jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscext.PortQnameBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscext.PortQnameBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscext.portqnamebinding.portqnamelocalnamelink", None), "portQnameLocalNameLink","com.ibm.etools.webservice.wscext.PortQnameBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscext.portqnamebinding.portqnamenamespacelink", None), "portQnameNamespaceLink","com.ibm.etools.webservice.wscext.PortQnameBinding");
  if len(atts) != 0:
    print "Modifying com.ibm.etools.webservice.wscext.PortQnameBinding with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "com.ibm.etools.webservice.wscext.PortQnameBinding configuration up to date.";

  sslConfig = Util.getOptionalAttribute(objid, 'sslConfig', "com.ibm.etools.webservice.wscext.PortQnameBinding");
  if sslConfig is not None and len(sslConfig) > 0:
    Util.remove(sslConfig);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSSLConfig":
        SSLConfig.create(objid, curjsonobject, "sslConfig");
  Util.popPathElement('com.ibm.etools.webservice.wscext.PortQnameBinding');
