from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonbnd.EncryptionKey')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherecom.ibm.etools.webservice.wscommonbnd.EncryptionKey");
  exportedObject.put("roleName", "WebSpherecom.ibm.etools.webservice.wscommonbnd.EncryptionKey");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonbnd.encryptionkey.name", objid, "name","com.ibm.etools.webservice.wscommonbnd.EncryptionKey");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonbnd.encryptionkey.locatorref", objid, "locatorRef","com.ibm.etools.webservice.wscommonbnd.EncryptionKey");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('com.ibm.etools.webservice.wscommonbnd.EncryptionKey');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonbnd.EncryptionKey')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscommonbnd.EncryptionKey resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.encryptionkey.name", None));
  Util.addIfNotNone(properties, "locatorRef", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.encryptionkey.locatorref", None));
  print "Creating com.ibm.etools.webservice.wscommonbnd.EncryptionKey with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("com.ibm.etools.webservice.wscommonbnd.EncryptionKey", parentid, properties);
  Util.popPathElement('com.ibm.etools.webservice.wscommonbnd.EncryptionKey');

def update(objid,jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonbnd.EncryptionKey')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscommonbnd.EncryptionKey resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.encryptionkey.name", None), "name","com.ibm.etools.webservice.wscommonbnd.EncryptionKey");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.encryptionkey.locatorref", None), "locatorRef","com.ibm.etools.webservice.wscommonbnd.EncryptionKey");
  if len(atts) != 0:
    print "Modifying com.ibm.etools.webservice.wscommonbnd.EncryptionKey with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "com.ibm.etools.webservice.wscommonbnd.EncryptionKey configuration up to date.";

  Util.popPathElement('com.ibm.etools.webservice.wscommonbnd.EncryptionKey');
